/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.processing.function.core;

import java.util.ArrayList;
import java.util.Map;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AbstractAnimalPenBlockEntity;
import lv.id.bonne.animalpen.interaction.value.Value;
import lv.id.bonne.animalpen.items.component.StoredMobData;
import lv.id.bonne.animalpen.processing.function.api.EntityFunction;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.util.ItemTransferUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TurtleScuteDrop
implements EntityFunction.ProcessEntityFunction {
    @Override
    public boolean processFunction(ServerLevel serverLevel, Mob mob, ItemStack componentHolder, BlockPos blockPos, String dataKey, Value dataValue) {
        ItemStack stack2;
        if (!(mob instanceof Turtle)) {
            return false;
        }
        if (!componentHolder.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())) {
            AnimalPen.LOGGER.error("FAILED to process turtle scutes as data is missing.");
            return false;
        }
        StoredMobData storedMobData = (StoredMobData)componentHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
        Map<String, Integer> properties = storedMobData.properties();
        if (!properties.containsKey("last_feeding_increment")) {
            return false;
        }
        int count = properties.getOrDefault("last_feeding_increment", 0);
        ArrayList<ItemStack> scuteList = new ArrayList<ItemStack>();
        do {
            stack2 = Items.TURTLE_SCUTE.getDefaultInstance();
            stack2.setCount(Math.min(count, stack2.getMaxStackSize()));
            scuteList.add(stack2);
        } while ((count -= stack2.getCount()) > 0);
        BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos);
        if (blockEntity instanceof AbstractAnimalPenBlockEntity) {
            AbstractAnimalPenBlockEntity animalPenBlockEntity = (AbstractAnimalPenBlockEntity)blockEntity;
            scuteList.forEach(stack -> ItemTransferUtil.insertBellowOrDrop((Level)serverLevel, stack, animalPenBlockEntity.getBlockPos(), animalPenBlockEntity.dropPosition()));
        } else {
            scuteList.forEach(stack -> Block.popResource((Level)mob.level(), (BlockPos)blockPos.above(), (ItemStack)stack));
        }
        componentHolder.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(storedMobData.animalCount(), properties, storedMobData.cooldowns()));
        return true;
    }
}

