/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.processing.function.core;

import java.util.Map;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interaction.value.Value;
import lv.id.bonne.animalpen.items.component.StoredMobData;
import lv.id.bonne.animalpen.processing.function.api.EntityFunction;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;

public class Feeding
implements EntityFunction {
    private final boolean fullIncrement;

    public Feeding(boolean fullIncrement) {
        this.fullIncrement = fullIncrement;
    }

    @Override
    public boolean interactPlayer(ServerPlayer player, InteractionHand interactionHand, ItemStack itemConsumed, int amount, Mob mob, ItemStack componentHolder, BlockPos blockPos, String dataKey, Value dataValue) {
        this.processData(player.serverLevel(), itemConsumed, amount, mob, componentHolder, blockPos);
        if (mob instanceof Animal) {
            Animal animal = (Animal)mob;
            if (AnimalPen.config().isTriggerAdvancements()) {
                for (int i = 0; i < amount; ++i) {
                    CriteriaTriggers.BRED_ANIMALS.trigger(player, animal, animal, (AgeableMob)animal);
                }
            }
            if (AnimalPen.config().isIncreaseStatistics()) {
                player.awardStat(Stats.ANIMALS_BRED, amount);
            }
        }
        return true;
    }

    @Override
    public boolean interactDispenser(ServerLevel serverLevel, Container dispenserInventory, ItemStack itemConsumed, int amount, Mob mob, ItemStack componentHolder, BlockPos blockPos, String dataKey, Value dataValue) {
        this.processData(serverLevel, itemConsumed, amount, mob, componentHolder, blockPos);
        return true;
    }

    private void processData(ServerLevel serverLevel, ItemStack itemConsumed, int amount, Mob mob, ItemStack componentHolder, BlockPos blockPos) {
        if (!componentHolder.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())) {
            AnimalPen.LOGGER.error("FAILED to feed animal as data is missing.");
            return;
        }
        if (!this.fullIncrement) {
            amount /= 2;
        }
        StoredMobData storedMobData = (StoredMobData)componentHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
        long animalCount = storedMobData.animalCount();
        Map<String, Integer> properties = storedMobData.properties();
        properties.put("last_feeding_increment", (int)(animalCount += (long)amount) / 2);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, (double)((float)blockPos.getX() + 0.5f), (double)blockPos.getY() + 1.5, (double)((float)blockPos.getZ() + 0.5f), 5, 0.2, 0.2, 0.2, 0.05);
        serverLevel.playSound(null, blockPos, mob.getEatingSound(itemConsumed), SoundSource.NEUTRAL, 1.0f, Mth.randomBetween((RandomSource)serverLevel.getRandom(), (float)0.8f, (float)1.2f));
        componentHolder.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(animalCount, properties, storedMobData.cooldowns()));
    }
}

