/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.network.packets;

import dev.architectury.networking.NetworkManager;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.registries.AnimalPenInteractionRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public record AnimalInteractionSyncStartPacket(int entityCount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AnimalInteractionSyncStartPacket> ID = new CustomPacketPayload.Type(AnimalPen.resourceOf("start_data_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnimalInteractionSyncStartPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, AnimalInteractionSyncStartPacket::entityCount, AnimalInteractionSyncStartPacket::new);

    public static void handle(AnimalInteractionSyncStartPacket data, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            AnimalPenInteractionRegistry.clear();
            AnimalPenInteractionRegistry.setEntityCount(data.entityCount());
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

