/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.network.packets;

import com.mojang.serialization.Codec;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interaction.model.AnimalInteraction;
import lv.id.bonne.animalpen.registries.AnimalPenInteractionRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public record AnimalInteractionSyncEntityPacket(ResourceKey<EntityType<?>> entityId, List<AnimalInteraction> interactions) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AnimalInteractionSyncEntityPacket> ID = new CustomPacketPayload.Type(AnimalPen.resourceOf("perform_data_sync"));
    public static final StreamCodec<FriendlyByteBuf, AnimalInteractionSyncEntityPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.ENTITY_TYPE), AnimalInteractionSyncEntityPacket::entityId, (StreamCodec)ByteBufCodecs.fromCodec((Codec)AnimalInteraction.CODEC.listOf()), AnimalInteractionSyncEntityPacket::interactions, AnimalInteractionSyncEntityPacket::new);

    public static void handle(AnimalInteractionSyncEntityPacket data, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> AnimalPenInteractionRegistry.register(data.entityId(), data.interactions()));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

