/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.items.component.StoredMob;
import lv.id.bonne.animalpen.items.component.StoredMobData;
import lv.id.bonne.animalpen.items.component.StoredMobVariants;
import lv.id.bonne.animalpen.mixin.invokers.MobInvoker;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.util.AnimalPenVariantHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAnimalStorageItem
extends Item {
    protected AbstractAnimalStorageItem(Item.Properties properties) {
        super(properties);
    }

    protected abstract String tooltipKeyBase();

    protected abstract TagKey<EntityType<?>> pickableTag();

    @Nullable
    protected abstract BlockEntityHandler blockEntityHandler();

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        CompoundTag compoundTag;
        CustomData customData;
        super.verifyComponentsAfterLoad(itemStack);
        if (itemStack.has(DataComponents.CUSTOM_DATA)) {
            customData = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
            compoundTag = customData.getUnsafe();
            if (compoundTag.contains("animal_variants")) {
                ListTag nbtVariantList = compoundTag.getList("animal_variants", 10);
                ArrayList<CompoundTag> variantList = new ArrayList<CompoundTag>(nbtVariantList.size());
                nbtVariantList.forEach(tag -> variantList.add((CompoundTag)tag));
                itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get(), (Object)StoredMobVariants.of(variantList));
            }
            if (compoundTag.contains("animal_data")) {
                CompoundTag animalData = compoundTag.getCompound("animal_data");
                long animalCount = animalData.getLong("animal_count");
                CompoundTag cooldowns = animalData.getCompound("cooldown");
                HashMap<String, Integer> cooldownMap = new HashMap<String, Integer>(cooldowns.size());
                cooldowns.getAllKeys().forEach(key -> cooldownMap.put((String)key, cooldowns.getInt(key)));
                animalData.remove("animal_count");
                animalData.remove("cooldown");
                HashMap<String, Integer> propertiesMap = new HashMap<String, Integer>(animalData.size());
                animalData.getAllKeys().forEach(key -> propertiesMap.put((String)key, animalData.getInt(key)));
                itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(animalCount, propertiesMap, cooldownMap));
            }
            if (compoundTag.contains("animal")) {
                CompoundTag animal = compoundTag.getCompound("animal");
                String entityId = animal.getString("id");
                EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)entityId));
                itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get(), (Object)StoredMob.of(entityType, animal));
            }
            itemStack.remove(DataComponents.CUSTOM_DATA);
        }
        if (itemStack.has((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get())) {
            customData = (CustomData)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            ListTag nbtVariants = customData.getUnsafe().getList("animal_variants", 10);
            ArrayList<CompoundTag> variantList = new ArrayList<CompoundTag>(nbtVariants.size());
            nbtVariants.forEach(tag -> variantList.add((CompoundTag)tag));
            itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get(), (Object)StoredMobVariants.of(variantList));
            itemStack.remove((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        }
        if (itemStack.has(DataComponents.ENTITY_DATA)) {
            customData = (CustomData)itemStack.get(DataComponents.ENTITY_DATA);
            compoundTag = customData.getUnsafe();
            if (compoundTag.contains("animal_count")) {
                long animalCount = compoundTag.getLong("animal_count");
                HashMap<String, Integer> cooldownMap = new HashMap<String, Integer>(0);
                compoundTag.remove("animal_count");
                HashMap<String, Integer> propertiesMap = new HashMap<String, Integer>(0);
                itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(animalCount, propertiesMap, cooldownMap));
            }
            if (compoundTag.contains("id")) {
                String entityId = compoundTag.getString("id");
                EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)entityId));
                itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get(), (Object)StoredMob.of(entityType, compoundTag));
            }
            itemStack.remove(DataComponents.ENTITY_DATA);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, tooltip, tooltipFlag);
        if (!tooltip.isEmpty()) {
            tooltip.add((Component)Component.empty());
        }
        if (stack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get()) && stack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())) {
            StoredMob storedMob = (StoredMob)stack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
            StoredMobData storedMobData = (StoredMobData)stack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
            tooltip.add((Component)Component.translatable((String)(this.tooltipKeyBase() + ".entity"), (Object[])new Object[]{storedMob.entityType().getDescription()}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)(this.tooltipKeyBase() + ".amount"), (Object[])new Object[]{storedMobData.animalCount()}).withStyle(ChatFormatting.GRAY));
            if (stack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get())) {
                StoredMobVariants storedMobVariants = (StoredMobVariants)stack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get());
                tooltip.add((Component)Component.translatable((String)(this.tooltipKeyBase() + ".variants"), (Object[])new Object[]{storedMobVariants.variants().size()}).withStyle(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)(this.tooltipKeyBase() + ".release")).withStyle(ChatFormatting.GRAY));
        }
        if (!stack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())) {
            tooltip.add((Component)Component.translatable((String)(this.tooltipKeyBase() + ".tip")).withStyle(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, @NotNull Player player, LivingEntity target, InteractionHand hand) {
        AbstractChestedHorse h;
        AbstractHorse h2;
        OwnableEntity o;
        InteractionResult interactionResult = super.interactLivingEntity(stack, player, target, hand);
        if (interactionResult == InteractionResult.FAIL) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.unknown").withStyle(ChatFormatting.DARK_RED), true);
            return interactionResult;
        }
        if (player.level().isClientSide() || !(target instanceof Mob)) {
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        Mob mob = (Mob)target;
        if (!target.isAlive() || target.isBaby()) {
            this.error(player, ".error.baby");
            return InteractionResult.FAIL;
        }
        if (!target.getType().is(this.pickableTag())) {
            this.error(player, ".error.not_allowed");
            return InteractionResult.FAIL;
        }
        if (mob instanceof OwnableEntity && (o = (OwnableEntity)mob).getOwnerUUID() != null || mob instanceof AbstractHorse && (h2 = (AbstractHorse)mob).getOwnerUUID() != null) {
            this.error(player, ".error.tame");
            return InteractionResult.FAIL;
        }
        if (mob instanceof AbstractChestedHorse && (h = (AbstractChestedHorse)mob).hasChest()) {
            this.error(player, ".error.chested");
            return InteractionResult.FAIL;
        }
        if (!this.matchEntity(stack, (LivingEntity)mob)) {
            this.error(player, ".error.wrong");
            return InteractionResult.FAIL;
        }
        this.captureMob(stack, player, mob, hand);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return super.useOn(context);
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        BlockEntityHandler handler = this.blockEntityHandler();
        if (handler != null && handler.handle(blockEntity, player, context.getHand())) {
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching()) {
            return this.tryRelease(context);
        }
        return super.useOn(context);
    }

    private void captureMob(ItemStack stack, Player player, Mob mob, InteractionHand hand) {
        mob.ejectPassengers();
        if (mob.isPassenger()) {
            mob.stopRiding();
        }
        this.dropEquipment(mob);
        if (mob.isLeashed()) {
            mob.dropLeash(true, true);
        }
        if (!stack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())) {
            CompoundTag animalTag = new CompoundTag();
            mob.saveWithoutId(animalTag);
            animalTag.remove("Pos");
            animalTag.remove("UUID");
            stack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get(), (Object)StoredMob.of(mob.getType(), animalTag));
        }
        stack.update((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(0L, new HashMap<String, Integer>(), new HashMap<String, Integer>()), data -> StoredMobData.of(data.animalCount() + 1L, data.properties(), data.cooldowns()));
        AnimalPenVariantHelper.storeAnimalVariant(stack, mob, player);
        mob.remove(Entity.RemovalReason.DISCARDED);
        player.setItemInHand(hand, stack);
    }

    private InteractionResult tryRelease(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        if (!stack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())) {
            return InteractionResult.PASS;
        }
        ServerLevel level = (ServerLevel)context.getLevel();
        ListTag pos = new ListTag();
        BlockPos releaseBlock = context.getClickedPos().relative(context.getClickedFace());
        pos.add((Object)DoubleTag.valueOf((double)((double)releaseBlock.getX() + 0.5)));
        pos.add((Object)DoubleTag.valueOf((double)releaseBlock.getY()));
        pos.add((Object)DoubleTag.valueOf((double)((double)releaseBlock.getZ() + 0.5)));
        StoredMob storedMob = (StoredMob)stack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
        CompoundTag animal = storedMob.tag();
        animal.put("Pos", (Tag)pos);
        animal.remove("UUID");
        Entity mobEntity = storedMob.entityType().create((Level)level);
        if (!(mobEntity instanceof Mob)) {
            AnimalPen.sendDebug("Failed to spawn mob in given world.");
            return InteractionResult.SUCCESS;
        }
        Mob mob = (Mob)mobEntity;
        mob.load(animal);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            mob.setItemSlot(slot, ItemStack.EMPTY);
        }
        level.addFreshEntity((Entity)mob);
        this.decrementStoredAmount(stack);
        return InteractionResult.SUCCESS;
    }

    private void decrementStoredAmount(ItemStack stack) {
        StoredMobData data = (StoredMobData)stack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
        if (data == null || data.animalCount() <= 1L) {
            stack.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
            stack.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
            stack.remove((DataComponentType)AnimalPenDataComponentRegistry.MOB_VARIANT_COMPONENT.get());
        } else {
            stack.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(data.animalCount() - 1L, data.properties(), data.cooldowns()));
        }
    }

    private void dropEquipment(Mob mob) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!mob.hasItemInSlot(slot)) continue;
            ItemStack stack = mob.getItemBySlot(slot);
            if (mob.getRandom().nextFloat() < ((MobInvoker)mob).callGetEquipmentDropChance(slot)) {
                Block.popResource((Level)mob.level(), (BlockPos)mob.blockPosition(), (ItemStack)stack);
            }
            mob.setDropChance(slot, 0.0f);
        }
    }

    private boolean matchEntity(ItemStack stack, LivingEntity entity) {
        if (!stack.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())) {
            return true;
        }
        return entity.getType() == ((StoredMob)stack.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())).entityType();
    }

    private void error(Player player, String suffix) {
        player.displayClientMessage((Component)Component.translatable((String)(this.tooltipKeyBase() + suffix)).withStyle(ChatFormatting.DARK_RED), true);
    }

    @FunctionalInterface
    protected static interface BlockEntityHandler {
        public boolean handle(BlockEntity var1, Player var2, InteractionHand var3);
    }
}

