/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.interaction.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interaction.condition.ConditionEntry;
import lv.id.bonne.animalpen.interaction.cooldown.CooldownEntry;
import lv.id.bonne.animalpen.interaction.function.FunctionKey;
import lv.id.bonne.animalpen.interaction.ingredient.ConsumerEntry;
import lv.id.bonne.animalpen.interaction.ingredient.CustomIngredient;
import lv.id.bonne.animalpen.interaction.loot.LootEntry;
import lv.id.bonne.animalpen.interaction.model.AnimalInteraction;
import lv.id.bonne.animalpen.interaction.textentry.TextEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AnimalInteractionBuilder {
    private final List<ConditionEntry> conditions = new ArrayList<ConditionEntry>();
    private final List<TextEntry> textLines = new ArrayList<TextEntry>();
    private final List<FunctionKey> runFunctions = new ArrayList<FunctionKey>();
    private final List<FunctionKey> finishFunctions = new ArrayList<FunctionKey>();
    private String id;
    private CustomIngredient ingredient = CustomIngredient.EMPTY;
    private ConsumerEntry consume = new ConsumerEntry.Interact();
    private LootEntry lootEntry = null;
    private boolean even = false;
    private CooldownEntry cooldown = null;
    private ResourceLocation sound = null;
    private int redstoneBit = 0;

    private AnimalInteractionBuilder() {
    }

    public AnimalInteractionBuilder ingredient(CustomIngredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public AnimalInteractionBuilder consume(ConsumerEntry consume) {
        this.consume = consume;
        return this;
    }

    public AnimalInteractionBuilder conditions(List<ConditionEntry> conditions) {
        this.conditions.addAll(conditions);
        return this;
    }

    public AnimalInteractionBuilder conditions(ConditionEntry conditions) {
        this.conditions.add(conditions);
        return this;
    }

    public AnimalInteractionBuilder lootEntry(LootEntry lootEntry) {
        this.lootEntry = lootEntry;
        return this;
    }

    public AnimalInteractionBuilder even(boolean even) {
        this.even = even;
        return this;
    }

    public AnimalInteractionBuilder cooldown(CooldownEntry cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public AnimalInteractionBuilder textLines(TextEntry textLines) {
        this.textLines.add(textLines);
        return this;
    }

    public AnimalInteractionBuilder runFunctions(FunctionKey ... startFunctions) {
        this.runFunctions.addAll(Arrays.asList(startFunctions));
        return this;
    }

    public AnimalInteractionBuilder finishFunctions(FunctionKey ... endFunctions) {
        this.finishFunctions.addAll(Arrays.asList(endFunctions));
        return this;
    }

    public AnimalInteractionBuilder sound(ResourceLocation sound) {
        this.sound = sound;
        return this;
    }

    public AnimalInteractionBuilder redstoneBit(int redstoneBit) {
        if (redstoneBit > 4 || redstoneBit < 0) {
            AnimalPen.LOGGER.error("REDSTONE BIT value is out of bounds.");
        }
        this.redstoneBit = Mth.clamp((int)redstoneBit, (int)0, (int)4);
        return this;
    }

    public AnimalInteraction build() {
        return new AnimalInteraction(this.id, this.ingredient, this.conditions, this.even, this.consume, this.lootEntry, this.cooldown, this.textLines, this.runFunctions, this.finishFunctions, this.sound, this.redstoneBit);
    }

    public static AnimalInteractionBuilder create(String id) {
        AnimalInteractionBuilder builder = new AnimalInteractionBuilder();
        builder.id = id;
        return builder;
    }
}

