/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.interaction.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lv.id.bonne.animalpen.interaction.condition.ConditionEntry;
import lv.id.bonne.animalpen.interaction.cooldown.CooldownEntry;
import lv.id.bonne.animalpen.interaction.function.FunctionKey;
import lv.id.bonne.animalpen.interaction.ingredient.ConsumerEntry;
import lv.id.bonne.animalpen.interaction.ingredient.CustomIngredient;
import lv.id.bonne.animalpen.interaction.loot.LootEntry;
import lv.id.bonne.animalpen.interaction.textentry.TextEntry;
import lv.id.bonne.animalpen.items.component.StoredMobData;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.util.CustomCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AnimalInteraction(@NotNull String id, @NotNull CustomIngredient ingredient, @NotNull List<ConditionEntry> conditions, boolean even, @Nullable ConsumerEntry consumer, @Nullable LootEntry lootEntry, @Nullable CooldownEntry cooldown, @NotNull List<TextEntry> textLines, @NotNull List<FunctionKey> runFunctions, @NotNull List<FunctionKey> finishFunctions, @Nullable ResourceLocation sound, int redstoneSignal) {
    public static final Codec<AnimalInteraction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(a -> a.id), (App)CustomIngredient.CODEC.optionalFieldOf("items", (Object)CustomIngredient.EMPTY).forGetter(a -> a.ingredient), (App)CustomCodec.strictOptionalListField("conditions", ConditionEntry.CODEC).forGetter(a -> a.conditions), (App)Codec.BOOL.optionalFieldOf("even_entity_count", (Object)false).forGetter(a -> a.even), (App)ConsumerEntry.CODEC.optionalFieldOf("consumer", (Object)new ConsumerEntry.Interact()).forGetter(a -> a.consumer), (App)LootEntry.CODEC.optionalFieldOf("loot").forGetter(a -> Optional.ofNullable(a.lootEntry)), (App)CooldownEntry.CODEC.optionalFieldOf("cooldown").forGetter(a -> Optional.ofNullable(a.cooldown)), (App)CustomCodec.strictOptionalListField("text_lines", TextEntry.CODEC).forGetter(a -> a.textLines), (App)CustomCodec.strictOptionalListField("run_functions", FunctionKey.CODEC).forGetter(a -> a.runFunctions), (App)CustomCodec.strictOptionalListField("finish_functions", FunctionKey.CODEC).forGetter(a -> a.finishFunctions), (App)ResourceLocation.CODEC.optionalFieldOf("sound").forGetter(a -> Optional.ofNullable(a.sound)), (App)Codec.INT.optionalFieldOf("redstone_signal", (Object)0).forGetter(a -> a.redstoneSignal)).apply((Applicative)instance, (id, ingredient, conditions, even, consumer, lootEntry, cooldown, textLines, runFunctions, finishFunctions, sound, redstoneSignal) -> new AnimalInteraction((String)id, (CustomIngredient)ingredient, (List<ConditionEntry>)conditions, (boolean)even, (ConsumerEntry)consumer, lootEntry.orElse(null), cooldown.orElse(null), (List<TextEntry>)textLines, (List<FunctionKey>)runFunctions, (List<FunctionKey>)finishFunctions, sound.orElse(null), (int)redstoneSignal)));

    public boolean matchAllConditions(DataComponentHolder dataHolder) {
        return this.conditions().stream().allMatch(condition -> condition.matchCondition(dataHolder));
    }

    public long normalizeMobCount(long mobCount) {
        if (this.even && (mobCount & 1L) == 1L) {
            return mobCount - 1L;
        }
        return mobCount;
    }

    public boolean applyCooldown(ItemStack mobNBT, long mobCount) {
        if (this.cooldown == null) {
            return false;
        }
        StoredMobData storedMobData = (StoredMobData)mobNBT.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
        Map<String, Integer> cooldowns = storedMobData.cooldowns();
        cooldowns.put(this.id, (int)this.cooldown.calculateCooldown(mobCount));
        mobNBT.set((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get(), (Object)StoredMobData.of(storedMobData.animalCount(), storedMobData.properties(), cooldowns));
        return true;
    }

    public boolean triggerFunctions(@NotNull ServerPlayer player, InteractionHand interactionHand, ItemStack consumedItem, int consumedAmount, @NotNull Mob mob, @NotNull ItemStack componentHolder, @NotNull BlockPos position) {
        boolean dataUpdate = false;
        for (FunctionKey function : this.runFunctions) {
            dataUpdate |= function.id().interactPlayer(player, interactionHand, consumedItem, consumedAmount, mob, componentHolder, position, function.key(), function.value());
        }
        return dataUpdate;
    }

    public boolean triggerFunctions(ServerLevel level, Container container, ItemStack consumedItem, int consumedAmount, Mob mob, @NotNull ItemStack componentHolder, BlockPos position) {
        boolean dataUpdate = false;
        for (FunctionKey function : this.runFunctions) {
            dataUpdate |= function.id().interactDispenser(level, container, consumedItem, consumedAmount, mob, componentHolder, position, function.key(), function.value());
        }
        return dataUpdate;
    }
}

