/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.interaction.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record LootEntry(ResourceKey<LootTable> lootTable, int dropLimit, boolean perEntity) {
    public static final Codec<LootEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("id").forGetter(LootEntry::lootTable), (App)Codec.INT.fieldOf("drop_limit").forGetter(LootEntry::dropLimit), (App)Codec.BOOL.fieldOf("per_entity").forGetter(LootEntry::perEntity)).apply((Applicative)instance, LootEntry::new));

    @NotNull
    public List<ItemStack> processLootTable(ServerLevel serverLevel, Mob animal, BlockPos blockPos, long animalCount, int consumedAmount) {
        ObjectArrayList randomItems;
        long rollCount;
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(this.lootTable());
        LootParams params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)animal).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos)).create(LootContextParamSets.GIFT);
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        long l = rollCount = this.perEntity() ? animalCount : (long)consumedAmount;
        for (int itemCount = this.dropLimit(); itemCount > 0 && rollCount-- > 0L && !(randomItems = lootTable.getRandomItems(params)).isEmpty(); itemCount -= randomItems.stream().mapToInt(ItemStack::getCount).sum()) {
            randomItems.forEach(item -> {
                boolean added = false;
                for (ItemStack stack : itemStackList) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack) || stack.getCount() + item.getCount() > stack.getMaxStackSize()) continue;
                    stack.grow(item.getCount());
                    added = true;
                    break;
                }
                if (!added) {
                    itemStackList.add((ItemStack)item);
                }
            });
        }
        return itemStackList;
    }

    public static LootEntry of(ResourceKey<LootTable> lootTable, int dropLimit, boolean perEntity) {
        return new LootEntry(lootTable, dropLimit, perEntity);
    }

    public static LootEntry of(ResourceKey<LootTable> lootTable) {
        return LootEntry.of(lootTable, Integer.MAX_VALUE, false);
    }

    public static LootEntry of(ResourceLocation lootTable, int dropLimit, boolean perEntity) {
        return LootEntry.of((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable), dropLimit, perEntity);
    }

    public static LootEntry of(ResourceLocation lootTable) {
        return LootEntry.of(lootTable, Integer.MAX_VALUE, false);
    }
}

