/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.interaction.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.processing.executor.AnimalInteractionExecutor;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public sealed interface ConsumerEntry {
    public static final Codec<ConsumerEntry> CODEC = ConsumerType.CODEC.dispatch("type", entry -> {
        ConsumerEntry consumerEntry = entry;
        Objects.requireNonNull(consumerEntry);
        ConsumerEntry selector0$temp = consumerEntry;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Damage.class, Replace.class, Interact.class, Consume.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Damage d = (Damage)selector0$temp;
                yield ConsumerType.DAMAGE;
            }
            case 1 -> {
                Replace r = (Replace)selector0$temp;
                yield ConsumerType.REPLACE;
            }
            case 2 -> {
                Interact i = (Interact)selector0$temp;
                yield ConsumerType.INTERACT;
            }
            case 3 -> {
                Consume c = (Consume)selector0$temp;
                yield ConsumerType.CONSUME;
            }
        };
    }, type -> switch (type.ordinal()) {
        default -> throw new MatchException(null, null);
        case 0 -> Damage.CODEC;
        case 1 -> Replace.CODEC;
        case 2 -> Interact.CODEC;
        case 3 -> Consume.CODEC;
    });

    public ItemStack getConsumedItem(ItemStack var1);

    public long calculateConsumption(AnimalInteractionExecutor var1, ItemStack var2, long var3, boolean var5);

    public ItemStack consumeItems(AnimalInteractionExecutor var1, List<ItemStack> var2, ItemStack var3, int var4);

    public static enum ConsumerType implements StringRepresentable
    {
        DAMAGE("damage"),
        REPLACE("replace"),
        INTERACT("interact"),
        CONSUME("consume");

        public static final Codec<ConsumerType> CODEC;
        private final String name;

        private ConsumerType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ConsumerType::values);
        }
    }

    public record Damage(int damage) implements ConsumerEntry
    {
        public static final MapCodec<Damage> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("damage").forGetter(Damage::damage)).apply((Applicative)instance, Damage::new));

        @Override
        public ItemStack getConsumedItem(ItemStack itemInHand) {
            return ItemStack.EMPTY;
        }

        @Override
        public long calculateConsumption(AnimalInteractionExecutor executor, ItemStack itemStack, long animalCount, boolean evenCount) {
            return 1L;
        }

        @Override
        public ItemStack consumeItems(AnimalInteractionExecutor executor, List<ItemStack> lootItems, ItemStack itemInHand, int consumedAmount) {
            executor.damageItem(itemInHand, this.damage);
            lootItems.forEach(executor::drop);
            return itemInHand;
        }
    }

    public record Replace() implements ConsumerEntry
    {
        public static final MapCodec<Replace> CODEC = MapCodec.unit((Object)new Replace());

        @Override
        public ItemStack getConsumedItem(ItemStack itemInHand) {
            return itemInHand.copy();
        }

        @Override
        public long calculateConsumption(AnimalInteractionExecutor executor, ItemStack itemStack, long animalCount, boolean evenCount) {
            return 1L;
        }

        @Override
        public ItemStack consumeItems(AnimalInteractionExecutor executor, List<ItemStack> lootItems, ItemStack itemInHand, int consumedAmount) {
            if (lootItems.isEmpty()) {
                executor.consume(itemInHand, 1);
                return itemInHand;
            }
            Iterator<ItemStack> iterator = lootItems.iterator();
            itemInHand = executor.giveFirst(itemInHand, iterator.next());
            iterator.forEachRemaining(executor::drop);
            return itemInHand;
        }
    }

    public record Interact() implements ConsumerEntry
    {
        public static final MapCodec<Interact> CODEC = MapCodec.unit((Object)new Interact());

        @Override
        public ItemStack getConsumedItem(ItemStack itemInHand) {
            return ItemStack.EMPTY;
        }

        @Override
        public long calculateConsumption(AnimalInteractionExecutor executor, ItemStack itemStack, long animalCount, boolean evenCount) {
            return 1L;
        }

        @Override
        public ItemStack consumeItems(AnimalInteractionExecutor executor, List<ItemStack> lootItems, ItemStack itemInHand, int consumedAmount) {
            lootItems.forEach(executor::drop);
            return itemInHand;
        }
    }

    public record Consume(boolean limitToStack) implements ConsumerEntry
    {
        public static final MapCodec<Consume> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("limit_to_stack").forGetter(Consume::limitToStack)).apply((Applicative)instance, Consume::new));

        @Override
        public ItemStack getConsumedItem(ItemStack itemInHand) {
            return itemInHand.copy();
        }

        @Override
        public long calculateConsumption(AnimalInteractionExecutor executor, ItemStack itemStack, long animalCount, boolean evenCount) {
            long consumedAmount = !this.limitToStack ? (long)executor.countAvailable(itemStack) : (long)itemStack.getCount();
            consumedAmount = Math.min(animalCount, consumedAmount);
            if (evenCount && (consumedAmount & 1L) == 1L) {
                --consumedAmount;
            }
            return consumedAmount;
        }

        @Override
        public ItemStack consumeItems(AnimalInteractionExecutor executor, List<ItemStack> lootItems, ItemStack itemInHand, int consumedAmount) {
            executor.consume(itemInHand, consumedAmount);
            lootItems.forEach(executor::drop);
            return ItemStack.EMPTY;
        }
    }
}

