/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.interaction.cooldown;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public sealed interface CooldownEntry {
    public static final Codec<CooldownEntry> CODEC = CooldownType.CODEC.dispatch("type", entry -> {
        CooldownEntry cooldownEntry = entry;
        Objects.requireNonNull(cooldownEntry);
        CooldownEntry selector0$temp = cooldownEntry;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Linear.class, Static.class, Randomized.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Linear l = (Linear)selector0$temp;
                yield CooldownType.LINEAR;
            }
            case 1 -> {
                Static s = (Static)selector0$temp;
                yield CooldownType.STATIC;
            }
            case 2 -> {
                Randomized r = (Randomized)selector0$temp;
                yield CooldownType.RANDOM;
            }
        };
    }, type -> switch (type.ordinal()) {
        default -> throw new MatchException(null, null);
        case 0 -> Linear.CODEC;
        case 1 -> Static.CODEC;
        case 2 -> Randomized.CODEC;
    });

    public long calculateCooldown(long var1);

    public static enum CooldownType implements StringRepresentable
    {
        LINEAR("linear"),
        STATIC("static"),
        RANDOM("random");

        public static final Codec<CooldownType> CODEC;
        private final String name;

        private CooldownType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(CooldownType::values);
        }
    }

    public record Linear(int base, int delta, int limit) implements CooldownEntry
    {
        public static final MapCodec<Linear> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("base").forGetter(Linear::base), (App)Codec.INT.fieldOf("delta").forGetter(Linear::delta), (App)Codec.INT.fieldOf("limit").forGetter(Linear::limit)).apply((Applicative)instance, Linear::new));

        @Override
        public long calculateCooldown(long animalCount) {
            long value = (long)this.base + animalCount * (long)this.delta;
            return this.delta >= 0 ? Mth.clamp((long)value, (long)this.base, (long)this.limit) : Mth.clamp((long)value, (long)this.limit, (long)this.base);
        }
    }

    public record Static(int base) implements CooldownEntry
    {
        public static final MapCodec<Static> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("base").forGetter(Static::base)).apply((Applicative)instance, Static::new));

        @Override
        public long calculateCooldown(long animalCount) {
            return this.base;
        }
    }

    public record Randomized(int min, int max) implements CooldownEntry
    {
        public static final Random RANDOM = new Random();
        public static final MapCodec<Randomized> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(Randomized::min), (App)Codec.INT.fieldOf("max").forGetter(Randomized::max)).apply((Applicative)instance, Randomized::new));

        @Override
        public long calculateCooldown(long animalCount) {
            return this.min + RANDOM.nextInt(this.max - this.min + 1);
        }
    }
}

