/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.interaction.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import lv.id.bonne.animalpen.interaction.condition.Operator;
import lv.id.bonne.animalpen.interaction.value.BoolValue;
import lv.id.bonne.animalpen.interaction.value.IntValue;
import lv.id.bonne.animalpen.interaction.value.TagValue;
import lv.id.bonne.animalpen.interaction.value.Value;
import lv.id.bonne.animalpen.items.component.StoredMob;
import lv.id.bonne.animalpen.items.component.StoredMobData;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public sealed interface ConditionEntry {
    public static final Codec<ConditionEntry> CODEC = ConditionType.CODEC.dispatch("type", entry -> {
        ConditionEntry conditionEntry = entry;
        Objects.requireNonNull(conditionEntry);
        ConditionEntry selector0$temp = conditionEntry;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AmountCondition.class, MobCondition.class, PropertiesCondition.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AmountCondition ignored = (AmountCondition)selector0$temp;
                yield ConditionType.AMOUNT;
            }
            case 1 -> {
                MobCondition ignored = (MobCondition)selector0$temp;
                yield ConditionType.MOB;
            }
            case 2 -> {
                PropertiesCondition ignored = (PropertiesCondition)selector0$temp;
                yield ConditionType.PROPERTIES;
            }
        };
    }, type -> switch (type.ordinal()) {
        default -> throw new MatchException(null, null);
        case 0 -> AmountCondition.CODEC;
        case 1 -> MobCondition.CODEC;
        case 2 -> PropertiesCondition.CODEC;
    });

    public boolean matchCondition(DataComponentHolder var1);

    public static enum ConditionType implements StringRepresentable
    {
        AMOUNT("amount"),
        MOB("mob"),
        PROPERTIES("data");

        public static final Codec<ConditionType> CODEC;
        private final String name;

        private ConditionType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ConditionType::values);
        }
    }

    public record AmountCondition(Operator operator, int value) implements ConditionEntry
    {
        public static final MapCodec<AmountCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Operator.CODEC.fieldOf("operator").forGetter(AmountCondition::operator), (App)Codec.INT.fieldOf("value").forGetter(AmountCondition::value)).apply((Applicative)inst, AmountCondition::new));

        @Override
        public boolean matchCondition(DataComponentHolder dataHolder) {
            if (!dataHolder.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())) {
                return false;
            }
            StoredMobData storedMobData = (StoredMobData)dataHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
            return this.operator.test(new IntValue((int)storedMobData.animalCount()), new IntValue(this.value));
        }
    }

    public record MobCondition(String key, Operator operator, Value value) implements ConditionEntry
    {
        public static final MapCodec<MobCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.fieldOf("key").forGetter(MobCondition::key), (App)Operator.CODEC.fieldOf("operator").forGetter(MobCondition::operator), (App)Value.CODEC.fieldOf("value").forGetter(MobCondition::value)).apply((Applicative)inst, MobCondition::new));

        @Override
        public boolean matchCondition(DataComponentHolder dataHolder) {
            if (!dataHolder.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get())) {
                return false;
            }
            StoredMob storedMob = (StoredMob)dataHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_COMPONENT.get());
            Record dataValue = this.operator == Operator.HAS ? new BoolValue(storedMob.tag().contains(this.key)) : new TagValue(storedMob.tag().get(this.key));
            return this.operator.test((Value)((Object)dataValue), this.value);
        }
    }

    public record PropertiesCondition(String key, Operator operator, Value value) implements ConditionEntry
    {
        public static final MapCodec<PropertiesCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.fieldOf("key").forGetter(PropertiesCondition::key), (App)Operator.CODEC.fieldOf("operator").forGetter(PropertiesCondition::operator), (App)Value.CODEC.fieldOf("value").forGetter(PropertiesCondition::value)).apply((Applicative)inst, PropertiesCondition::new));

        @Override
        public boolean matchCondition(DataComponentHolder dataHolder) {
            if (!dataHolder.has((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get())) {
                return false;
            }
            StoredMobData storedMobData = (StoredMobData)dataHolder.get((DataComponentType)AnimalPenDataComponentRegistry.MOB_DATA_COMPONENT.get());
            return this.operator.test(new IntValue(storedMobData.properties().getOrDefault(this.key, 0)), this.value);
        }
    }
}

