/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.config.screen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import lv.id.bonne.animalpen.AnimalPen;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Requirement;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AnimalPenConfigScreen {
    private static final Requirement LOCAL_OR_OP_REQUIREMENT = AnimalPenConfigScreen::isLocalSide;

    public static Screen createConfigScreen(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)"title.animal_pen.config"));
        AnimalPenConfigScreen.buildClientConfig(builder);
        AnimalPenConfigScreen.buildServerConfig(builder);
        builder.setSavingRunnable(() -> {
            try {
                AnimalPen.CONFIG_MANAGER.writeConfig(true);
            }
            catch (IOException e) {
                AnimalPen.LOGGER.error("Failed to save config", (Throwable)e);
            }
        });
        return builder.build();
    }

    private static void buildClientConfig(ConfigBuilder builder) {
        ConfigCategory general = builder.getOrCreateCategory((Component)Component.translatable((String)"category.animal_pen.general"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"option.animal_pen.show_cooldowns_while_crouching"), AnimalPen.config().isShowCooldownsOnCrouch()).setDefaultValue(false).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.show_cooldowns_while_crouching.tooltip")).setSaveConsumer(newValue -> AnimalPen.config().setShowCooldownsOnCrouch((boolean)newValue)).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"option.animal_pen.show_all_interactions_above"), AnimalPen.config().isShowAllInteractions()).setDefaultValue(false).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.show_all_interactions_above.tooltip")).setSaveConsumer(newValue -> AnimalPen.config().setShowAllInteractions((boolean)newValue)).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((Component)Component.translatable((String)"option.animal_pen.growth_multiplier"), AnimalPen.config().getAnimalPenMobSize()).setDefaultValue(0.001f).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.growth_multiplier.tooltip")).setSaveConsumer(newValue -> AnimalPen.config().setGrowthMultiplier(newValue.floatValue())).build());
        SubCategoryBuilder animalPen = entryBuilder.startSubCategory((Component)Component.translatable((String)"category.animal_pen.animal_pen"));
        animalPen.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"option.animal_pen.animal_pen_mob_can_grow"), AnimalPen.config().isGrowAnimalPenMob()).setDefaultValue(false).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.animal_pen_mob_can_grow.tooltip")).setSaveConsumer(newValue -> AnimalPen.config().setGrowAnimalPenMob((boolean)newValue)).build());
        animalPen.add((AbstractConfigListEntry)entryBuilder.startFloatField((Component)Component.translatable((String)"option.animal_pen.animal_pen_mob_size"), AnimalPen.config().getAnimalPenMobSize()).setDefaultValue(0.33f).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.animal_pen_mob_size.tooltip")).setSaveConsumer(newValue -> AnimalPen.config().setAnimalPenMobSize(newValue.floatValue())).build());
        general.addEntry((AbstractConfigListEntry)animalPen.build());
        SubCategoryBuilder aquarium = entryBuilder.startSubCategory((Component)Component.translatable((String)"category.animal_pen.aquarium"));
        aquarium.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"option.animal_pen.aquarium_mob_can_grow"), AnimalPen.config().isGrowAquariumMob()).setDefaultValue(false).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.aquarium_mob_can_grow.tooltip")).setSaveConsumer(newValue -> AnimalPen.config().setGrowAquariumMob((boolean)newValue)).build());
        aquarium.add((AbstractConfigListEntry)entryBuilder.startFloatField((Component)Component.translatable((String)"option.animal_pen.aquarium_mob_size"), AnimalPen.config().getAquariumMobSize()).setDefaultValue(0.33f).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.aquarium_mob_size.tooltip")).setSaveConsumer(newValue -> AnimalPen.config().setAquariumMobSize(newValue.floatValue())).build());
        general.addEntry((AbstractConfigListEntry)aquarium.build());
        SubCategoryBuilder aviary = entryBuilder.startSubCategory((Component)Component.translatable((String)"category.animal_pen.aviary"));
        aviary.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"option.animal_pen.aviary_mob_can_grow"), AnimalPen.config().isGrowAviaryMob()).setDefaultValue(false).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.aviary_mob_can_grow.tooltip")).setSaveConsumer(newValue -> AnimalPen.config().setGrowAviaryMob((boolean)newValue)).build());
        aviary.add((AbstractConfigListEntry)entryBuilder.startFloatField((Component)Component.translatable((String)"option.animal_pen.aviary_mob_size"), AnimalPen.config().getAviaryMobSize()).setDefaultValue(0.33f).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.aviary_mob_size.tooltip")).setSaveConsumer(newValue -> AnimalPen.config().setAviaryMobSize(newValue.floatValue())).build());
        general.addEntry((AbstractConfigListEntry)aviary.build());
    }

    private static void buildServerConfig(ConfigBuilder builder) {
        ConfigCategory general = builder.getOrCreateCategory((Component)Component.translatable((String)"category.animal_pen.server"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        general.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"option.animal_pen.trigger_advancements"), AnimalPen.config().isTriggerAdvancements()).setDefaultValue(false).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.trigger_advancements.tooltip")).setRequirement(LOCAL_OR_OP_REQUIREMENT)).setSaveConsumer(newValue -> AnimalPen.config().setTriggerAdvancements((Boolean)newValue)).build());
        general.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"option.animal_pen.increase_statistics"), AnimalPen.config().isIncreaseStatistics()).setDefaultValue(false).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.increase_statistics.tooltip")).setRequirement(LOCAL_OR_OP_REQUIREMENT)).setSaveConsumer(newValue -> AnimalPen.config().setIncreaseStatistics((Boolean)newValue)).build());
        general.addEntry((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.translatable((String)"option.animal_pen.attack_cooldown"), AnimalPen.config().getAttackCooldown()).setDefaultValue(5).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.attack_cooldown.tooltip")).setRequirement(LOCAL_OR_OP_REQUIREMENT)).setSaveConsumer(newValue -> AnimalPen.config().setAttackCooldown((Integer)newValue)).build());
        general.addEntry((AbstractConfigListEntry)((LongFieldBuilder)entryBuilder.startLongField((Component)Component.translatable((String)"option.animal_pen.animal_limit_in_pen"), AnimalPen.config().getMaximalAnimalCount()).setDefaultValue(Integer.MAX_VALUE).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.animal_limit_in_pen.tooltip")).setRequirement(LOCAL_OR_OP_REQUIREMENT)).setSaveConsumer(newValue -> AnimalPen.config().setMaximalAnimalCount((long)newValue)).build());
        general.addEntry((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.translatable((String)"option.animal_pen.max_stored_animal_variants"), AnimalPen.config().getMaxStoredVariants()).setDefaultValue(16).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.max_stored_animal_variants.tooltip")).setRequirement(LOCAL_OR_OP_REQUIREMENT)).setSaveConsumer(newValue -> AnimalPen.config().setMaxStoredAnimalVariants((Integer)newValue)).build());
        general.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"option.animal_pen.debug"), AnimalPen.config().isDebug()).setDefaultValue(false).setTooltip(AnimalPenConfigScreen.tooltips("option.animal_pen.debug.tooltip")).setRequirement(LOCAL_OR_OP_REQUIREMENT)).setSaveConsumer(newValue -> AnimalPen.config().setDebug((Boolean)newValue)).build());
    }

    private static boolean isLocalSide() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return true;
        }
        return minecraft.hasSingleplayerServer();
    }

    private static Optional<Component[]> tooltips(String key) {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>(10);
        if (I18n.exists((String)key)) {
            lines.add(Component.translatable((String)key));
        }
        for (int i = 0; i < 10; ++i) {
            String subLine = key + "[" + i + "]";
            if (!I18n.exists((String)subLine)) continue;
            lines.add(Component.translatable((String)subLine));
        }
        if (lines.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(lines.toArray(new Component[0]));
    }
}

