/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.renderer;

import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AquariumTileEntity;
import lv.id.bonne.animalpen.blocks.renderer.AbstractAnimalPenRenderer;
import lv.id.bonne.animalpen.mixin.accessors.EntityAccessor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class AquariumRenderer
extends AbstractAnimalPenRenderer<AquariumTileEntity> {
    @Override
    protected float getAnimalVerticalOffset() {
        return 0.75f;
    }

    @Override
    protected float getAnimalSize() {
        return AnimalPen.config().getAquariumMobSize();
    }

    @Override
    protected boolean shouldGrowAnimals() {
        return AnimalPen.config().isGrowAquariumMob();
    }

    @Override
    protected double getTextStartHeight() {
        return 1.75;
    }

    @Override
    protected void configureAnimalPose(Mob animal, AquariumTileEntity tileEntity) {
        super.configureAnimalPose(animal, tileEntity);
        animal.setPose(Pose.SWIMMING);
        animal.setSwimming(true);
        ((EntityAccessor)animal).setWasTouchingWater(true);
        animal.walkAnimation.update(0.2f, 0.4f);
        if (animal.tickCount == tileEntity.getTickCounter()) {
            return;
        }
        if (animal instanceof Squid) {
            Squid squid = (Squid)animal;
            squid.xBodyRotO = squid.xBodyRot;
            if (squid.oldTentacleMovement == 0.0f) {
                squid.oldTentacleMovement = 1.0f / (squid.getRandom().nextFloat() + 1.0f) * 0.2f;
            }
            squid.tentacleMovement += squid.oldTentacleMovement;
            if ((double)squid.tentacleMovement > Math.PI * 2) {
                squid.tentacleMovement -= (float)Math.PI * 2;
                if (squid.getRandom().nextInt(10) == 0) {
                    squid.oldTentacleMovement = 1.0f / (squid.getRandom().nextFloat() + 1.0f) * 0.2f;
                }
            }
            squid.oldTentacleAngle = squid.tentacleAngle;
            squid.tentacleAngle = Mth.abs((float)Mth.sin((float)squid.tentacleMovement)) * (float)Math.PI * 0.25f;
            squid.xBodyRot = -45.0f + Mth.sin((float)((float)squid.tickCount * 0.1f)) * 2.0f;
        }
        if (animal instanceof Frog) {
            Frog frog = (Frog)animal;
            frog.swimIdleAnimationState.startIfStopped(frog.tickCount);
        }
    }

    public boolean shouldRenderOffScreen(AquariumTileEntity blockEntity) {
        return !blockEntity.getInventory().isEmpty();
    }

    public boolean shouldRender(AquariumTileEntity blockEntity, Vec3 vec3) {
        return AnimalPen.config().isGrowAquariumMob() || super.shouldRender((BlockEntity)blockEntity, vec3);
    }
}

