/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.blocks.entities.AbstractAnimalPenBlockEntity;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AquariumTileEntity
extends AbstractAnimalPenBlockEntity {
    public AquariumTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)AnimalPenTileEntityRegistry.AQUARIUM_TILE_ENTITY.get(), blockPos, blockState);
    }

    @Override
    public boolean canGrowEntity() {
        return AnimalPen.config().isGrowAquariumMob();
    }

    @Override
    public boolean validateItemStack(ItemStack itemStack) {
        return itemStack.is((Item)AnimalPensItemRegistry.ANIMAL_CONTAINER.get());
    }

    @Override
    public void triggerUpdate() {
        super.triggerUpdate();
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        BlockState oldState = this.getBlockState();
        BlockState newState = this.getBlockState();
        if (((Boolean)oldState.getValue((Property)AquariumBlock.FILLED)).booleanValue() == this.getInventory().isEmpty()) {
            newState = (BlockState)oldState.setValue((Property)AquariumBlock.FILLED, (Comparable)Boolean.valueOf(!this.getInventory().isEmpty()));
            this.level.setBlock(this.getBlockPos(), newState, 2);
            this.setChanged();
        }
        this.level.sendBlockUpdated(this.getBlockPos(), oldState, newState, 2);
    }

    @Override
    public BlockPos dropPosition() {
        return this.getBlockPos().above(2);
    }
}

