/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.behaviour;

import lv.id.bonne.animalpen.blocks.entities.AbstractAnimalPenBlockEntity;
import lv.id.bonne.animalpen.registries.AnimalPenBlockRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class UseToolsBehaviour
implements DispenseItemBehavior {
    private final DispenseItemBehavior originalBehaviour;
    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

    public UseToolsBehaviour(DispenseItemBehavior dispenseItemBehavior) {
        this.originalBehaviour = dispenseItemBehavior;
    }

    @NotNull
    public ItemStack dispense(BlockSource blockSource, ItemStack itemStack) {
        ServerLevel level = blockSource.level();
        if (!level.isClientSide()) {
            BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
            BlockState blockState = level.getBlockState(blockPos);
            if (!(blockState.is(AnimalPenTags.ANIMAL_PEN_BLOCKS) || blockState.is((Block)AnimalPenBlockRegistry.AQUARIUM.get()) || blockState.is((Block)AnimalPenBlockRegistry.AVIARY.get()))) {
                return this.originalBehaviour.dispense(blockSource, itemStack);
            }
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof AbstractAnimalPenBlockEntity) {
                AbstractAnimalPenBlockEntity ani = (AbstractAnimalPenBlockEntity)blockEntity;
                AbstractAnimalPenBlockEntity.InteractionResult result = ani.interactWithPen(level, blockSource, itemStack);
                ani.triggerUpdate();
                if (result.success()) {
                    return result.result();
                }
                return itemStack;
            }
        }
        return itemStack;
    }
}

