/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import lv.id.bonne.animalpen.blocks.AbstractAnimalContainerBlock;
import lv.id.bonne.animalpen.blocks.entities.AviaryTileEntity;
import lv.id.bonne.animalpen.registries.AnimalPenTags;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AviaryBlock
extends AbstractAnimalContainerBlock<AviaryTileEntity> {
    private final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)16.0);
    public static final MapCodec<AviaryBlock> CODEC = AviaryBlock.simpleCodec(AviaryBlock::new);

    public AviaryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Override
    protected TagKey<Item> getAttackToolTag() {
        return AnimalPenTags.AVIARY_ATTACK_TOOLS;
    }

    @Override
    protected BlockEntityType<AviaryTileEntity> getTileType() {
        return (BlockEntityType)AnimalPenTileEntityRegistry.AVIARY_TILE_ENTITY.get();
    }

    @Override
    public Item getContainerItem() {
        return (Item)AnimalPensItemRegistry.BIRD_CATCHER.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.SHAPE;
    }
}

