/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks;

import dev.architectury.hooks.level.entity.PlayerHooks;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AbstractAnimalPenBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAnimalContainerBlock<T extends AbstractAnimalPenBlockEntity>
extends HorizontalDirectionalBlock
implements EntityBlock {
    protected AbstractAnimalContainerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected abstract TagKey<Item> getAttackToolTag();

    protected abstract Item getContainerItem();

    protected abstract BlockEntityType<T> getTileType();

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemInteractionResult result = super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
        if (result == ItemInteractionResult.FAIL || interactionHand != InteractionHand.MAIN_HAND) {
            AnimalPen.sendDebug("Blocked by external forces");
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.is(this.getContainerItem())) {
            AbstractAnimalPenBlockEntity entity;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof AbstractAnimalPenBlockEntity && (entity = (AbstractAnimalPenBlockEntity)blockEntity).processContainer(player, interactionHand)) {
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof AbstractAnimalPenBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        AbstractAnimalPenBlockEntity entity = (AbstractAnimalPenBlockEntity)blockEntity;
        if (PlayerHooks.isFake((Player)player) && itemInHand.is(this.getAttackToolTag())) {
            this.attack(blockState, level, blockPos, player);
            return ItemInteractionResult.SUCCESS;
        }
        if (entity.interactWithPen(player, interactionHand)) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.FAIL;
    }

    public void attack(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity;
        ItemStack weapon = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (weapon.is(this.getAttackToolTag()) && !level.isClientSide() && (blockEntity = level.getBlockEntity(blockPos)) instanceof AbstractAnimalPenBlockEntity) {
            AbstractAnimalPenBlockEntity entity = (AbstractAnimalPenBlockEntity)blockEntity;
            if (player.getCooldowns().isOnCooldown(weapon.getItem())) {
                return;
            }
            entity.attackThePen(player, level);
            if (PlayerHooks.isFake((Player)player)) {
                return;
            }
            int cooldown = AnimalPen.config().getAttackCooldown();
            if (cooldown > 0) {
                player.getCooldowns().addCooldown(weapon.getItem(), cooldown);
            }
            return;
        }
        super.attack(blockState, level, blockPos, player);
    }

    public float getDestroyProgress(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos) {
        ItemStack weapon = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (weapon.is(this.getAttackToolTag())) {
            return 0.0f;
        }
        return super.getDestroyProgress(blockState, player, blockGetter, blockPos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int n;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof AbstractAnimalPenBlockEntity) {
            AbstractAnimalPenBlockEntity entity = (AbstractAnimalPenBlockEntity)be;
            n = entity.getRedStoneSignal();
        } else {
            n = 0;
        }
        return n;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!state.is(newState.getBlock()) && (tile = level.getBlockEntity(pos)) instanceof AbstractAnimalPenBlockEntity) {
            AbstractAnimalPenBlockEntity entity = (AbstractAnimalPenBlockEntity)tile;
            for (int i = 0; i < entity.getInventory().getContainerSize(); ++i) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)entity.getInventory().getItem(i));
            }
            entity.getInventory().clearContent();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <E extends BlockEntity> GameEventListener getListener(ServerLevel level, E blockEntity) {
        return super.getListener(level, blockEntity);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.getTileType().create(blockPos, blockState);
    }

    public <E extends BlockEntity> BlockEntityTicker<E> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<E> type) {
        return AbstractAnimalContainerBlock.createTickerHelper(type, this.getTileType(), (world, pos, blockState, tileEntity) -> tileEntity.tick());
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> type, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return type == expectedType ? ticker : null;
    }
}

