/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class AnimalPenRenderer
implements BlockEntityRenderer<AnimalPenTileEntity> {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final Font font;
    private Animal dyingAnimal;

    public AnimalPenRenderer() {
        this.font = this.minecraft.font;
    }

    public void render(AnimalPenTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Animal animal = tileEntity.getStoredAnimal().orElse(null);
        if (animal == null) {
            return;
        }
        if (this.dyingAnimal == null || this.dyingAnimal.getType() != animal.getType()) {
            this.dyingAnimal = null;
            CompoundTag cloneTag = new CompoundTag();
            animal.save(cloneTag);
            EntityType.create((CompoundTag)cloneTag, (Level)tileEntity.getLevel()).map(entity -> (Animal)entity).ifPresent(clone -> {
                this.dyingAnimal = clone;
                this.dyingAnimal.setPose(Pose.DYING);
                this.dyingAnimal.yBodyRot = 0.0f;
                this.dyingAnimal.setYRot(0.0f);
                this.dyingAnimal.yHeadRot = 0.0f;
                this.dyingAnimal.yHeadRotO = 0.0f;
                this.dyingAnimal.tickCount = 0;
                this.dyingAnimal.deathTime = 0;
            });
        }
        Direction facing = (Direction)tileEntity.getBlockState().getValue((Property)AnimalPenBlock.FACING);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        switch (facing) {
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            }
        }
        poseStack.translate(0.0f, 0.0f, 0.0f);
        this.renderAnimal(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        this.renderCounter(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        if (this.minecraft.player != null && this.minecraft.player.isCrouching() || !AnimalPen.config().isShowCooldownsOnCrouch()) {
            this.renderTextLines(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        }
        poseStack.popPose();
    }

    private void renderAnimal(Animal animal, AnimalPenTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        animal.yBodyRot = 0.0f;
        animal.setYRot(0.0f);
        animal.yHeadRot = 0.0f;
        animal.yHeadRotO = 0.0f;
        animal.tickCount = tileEntity.getTickCounter();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.25f, 0.0f);
        float animalSize = AnimalPen.config().getAnimalSize();
        poseStack.scale(animalSize, animalSize, animalSize);
        if (AnimalPen.config().isGrowAnimals()) {
            float scale = 1.0f + animalSize * (float)tileEntity.getAnimalDisplaySize() * AnimalPen.config().getGrowthMultiplier().floatValue();
            poseStack.scale(scale, scale, scale);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)animal).render((Entity)animal, 0.0f, partialTicks, poseStack, buffer, combinedLight);
        CompoundTag cloneTag = new CompoundTag();
        animal.save(cloneTag);
        tileEntity.getDeathTicker().forEach(tick -> {
            if (this.dyingAnimal != null) {
                this.dyingAnimal.deathTime = tick;
                this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)this.dyingAnimal).render((Entity)this.dyingAnimal, 0.0f, partialTicks, poseStack, buffer, combinedLight);
            }
        });
        poseStack.popPose();
    }

    private void renderCounter(Animal animal, AnimalPenTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        long count = tileEntity.getAnimalCount();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.125f, -0.51f);
        MutableComponent text = Component.translatable((String)"display.animal_pen.count", (Object[])new Object[]{count});
        int textWidth = this.font.width((FormattedText)text);
        float maxWidth = 30.0f;
        float scale = Math.min(1.0f, maxWidth / (float)textWidth) * 0.015f;
        poseStack.scale(-scale, -scale, 0.0f);
        double d = (double)(-textWidth) / 2.0;
        Objects.requireNonNull(this.font);
        poseStack.translate(d, (double)((float)(-9) / 2.0f), 0.0);
        this.font.drawInBatch((Component)text, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        poseStack.popPose();
    }

    private void renderTextLines(Animal animal, AnimalPenTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction facing;
        Vec3 facingVec;
        List<Pair<ItemStack[], Component>> textList = tileEntity.getCooldownLines(true);
        if (textList.isEmpty()) {
            return;
        }
        BlockPos blockPos = tileEntity.getBlockPos();
        Vec3 playerPos = this.minecraft.player.position();
        Vec3 toPlayer = new Vec3(playerPos.x() - (double)blockPos.getX(), 0.0, playerPos.z() - (double)blockPos.getZ());
        if (toPlayer.dot(facingVec = Vec3.atLowerCornerOf((Vec3i)(facing = (Direction)tileEntity.getBlockState().getValue((Property)AnimalPenBlock.FACING)).getNormal())) < 0.0) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        double totalHeight = 1.5 + 0.125 * (double)(textList.size() - 1);
        double maxWidth = 0.0;
        for (Pair<ItemStack[], Component> pair : textList) {
            maxWidth = Math.max(maxWidth, this.calculateMaxWidth(pair));
        }
        poseStack.pushPose();
        poseStack.translate(0.0, totalHeight, 0.0);
        maxWidth = -maxWidth / 2.0;
        for (int i = 0; i < textList.size(); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.0, -0.125 * (double)i, 0.0);
            poseStack.scale(-0.0125f, -0.0125f, 0.0125f);
            poseStack.translate(maxWidth, 0.0, 0.0);
            this.renderTextLine(textList.get(i), poseStack, buffer, combinedLight, combinedOverlay);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private double calculateMaxWidth(Pair<ItemStack[], Component> pair) {
        Component text = (Component)pair.getRight();
        ItemStack first = ((ItemStack[])pair.getLeft()).length > 0 ? ((ItemStack[])pair.getLeft())[0] : null;
        ItemStack second = ((ItemStack[])pair.getLeft()).length > 1 ? ((ItemStack[])pair.getLeft())[1] : null;
        int whiteSpace = this.font.width(" ");
        boolean isFirst = true;
        double width = 0.0;
        for (Component part : text.toFlatList(Style.EMPTY)) {
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) continue;
                if (!isFirst) {
                    width -= (double)whiteSpace;
                }
                width += (double)(16 - whiteSpace);
            } else if (content.equals("\ue001")) {
                if (second == null) continue;
                if (!isFirst) {
                    width -= (double)whiteSpace;
                }
                width += (double)(16 - whiteSpace);
            } else {
                width += (double)this.font.width((FormattedText)part);
            }
            isFirst = false;
        }
        return width;
    }

    private void renderTextLine(Pair<ItemStack[], Component> componentPair, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Component text = (Component)componentPair.getRight();
        ItemStack first = ((ItemStack[])componentPair.getLeft()).length > 0 ? ((ItemStack[])componentPair.getLeft())[0] : null;
        ItemStack second = ((ItemStack[])componentPair.getLeft()).length > 1 ? ((ItemStack[])componentPair.getLeft())[1] : null;
        int whiteSpace = this.font.width(" ");
        boolean isFirst = true;
        int leftOffset = 0;
        for (Component part : text.toFlatList(Style.EMPTY)) {
            poseStack.translate((float)leftOffset, 0.0f, 0.0f);
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) {
                    leftOffset = isFirst ? 0 : -whiteSpace;
                    continue;
                }
                poseStack.pushPose();
                poseStack.scale(-20.0f, -20.0f, 20.0f);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                this.minecraft.getItemRenderer().renderStatic(first, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, buffer, (Level)Minecraft.getInstance().level, 0);
                poseStack.popPose();
                leftOffset = 8 - whiteSpace;
            } else if (content.equals("\ue001")) {
                if (second == null) {
                    leftOffset = isFirst ? 0 : -whiteSpace;
                    continue;
                }
                poseStack.pushPose();
                poseStack.scale(-20.0f, -20.0f, 20.0f);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                this.minecraft.getItemRenderer().renderStatic(second, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, buffer, (Level)Minecraft.getInstance().level, 0);
                poseStack.popPose();
                leftOffset = 8 - whiteSpace;
            } else {
                poseStack.pushPose();
                this.font.drawInBatch(part, 0.0f, -6.0f, 0xFFFFFF, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
                poseStack.popPose();
                leftOffset = this.font.width((FormattedText)part);
            }
            isFirst = false;
        }
    }

    public boolean shouldRenderOffScreen(AnimalPenTileEntity blockEntity) {
        return !blockEntity.getInventory().isEmpty() && AnimalPen.config().isGrowAnimals();
    }

    public boolean shouldRender(AnimalPenTileEntity blockEntity, Vec3 vec3) {
        return AnimalPen.config().isGrowAnimals() || super.shouldRender((BlockEntity)blockEntity, vec3);
    }
}

