/*
 * Decompiled with CFR 0.152.
 */
package slexom.animal_feeding_trough.platform.common.mixin;

import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import slexom.animal_feeding_trough.platform.common.goal.entity.ai.SelfFeedGoal;
import slexom.animal_feeding_trough.platform.common.mixin.GoalSelectorAccessor;
import slexom.animal_feeding_trough.platform.common.mixin.TemptGoalAccessor;

@Mixin(value={Animal.class})
public class AnimalEntityMixin
extends Mob {
    @Unique
    private static final ItemStack[] FORBIDDEN_ITEMS = (ItemStack[])Arrays.stream(new Item[]{Items.CARROT_ON_A_STICK, Items.WARPED_FUNGUS_ON_A_STICK}).map(ItemStack::new).toArray(ItemStack[]::new);

    protected AnimalEntityMixin(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    private void AFTAddSelfFeedingGoal(EntityType<? extends Mob> entityType, Level world, CallbackInfo ci) {
        if (world == null) {
            return;
        }
        if (world.isClientSide) {
            return;
        }
        ((GoalSelectorAccessor)this.goalSelector).getGoals().stream().filter(prioritizedGoal -> prioritizedGoal.getGoal().getClass().equals(TemptGoal.class)).toList().forEach(prioritizedGoal -> {
            TemptGoal goal = (TemptGoal)prioritizedGoal.getGoal();
            PathfinderMob mob = ((TemptGoalAccessor)goal).getMob();
            double speed = ((TemptGoalAccessor)goal).getSpeed();
            Predicate<ItemStack> foodPredicate = ((TemptGoalAccessor)goal).getFoodPredicate();
            boolean hasForbiddenFood = false;
            for (ItemStack itemStack : FORBIDDEN_ITEMS) {
                if (!foodPredicate.test(itemStack)) continue;
                hasForbiddenFood = true;
                break;
            }
            if (!hasForbiddenFood) {
                this.goalSelector.addGoal(prioritizedGoal.getPriority() + 1, (Goal)new SelfFeedGoal((Animal)mob, speed, foodPredicate));
            }
        });
    }
}

