/*
 * Decompiled with CFR 0.152.
 */
package slexom.animal_feeding_trough.platform.common.block.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import slexom.animal_feeding_trough.platform.common.AnimalFeedingTroughMod;
import slexom.animal_feeding_trough.platform.common.block.FeedingTroughBlock;
import slexom.animal_feeding_trough.platform.common.inventory.BlockEntityInventory;
import slexom.animal_feeding_trough.platform.common.screen.FeedingTroughScreenHandler;

public class FeedingTroughBlockEntity
extends BlockEntity
implements MenuProvider,
BlockEntityInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final String NBT_STORED_EXP = "StoredExp";
    private int storedExp = 0;

    public FeedingTroughBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AnimalFeedingTroughMod.FEEDING_TROUGH_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, FeedingTroughBlockEntity blockEntity) {
        int currentLevel;
        if (world.isClientSide()) {
            return;
        }
        int count = blockEntity.getItem(0).getCount();
        int newLevel = 0;
        if (count > 0) {
            newLevel = Mth.floor((float)((float)blockEntity.getItem(0).getCount() / 16.0f)) + 1;
            newLevel = Math.min(newLevel, 4);
        }
        if ((currentLevel = ((Integer)state.getValue((Property)FeedingTroughBlock.LEVEL)).intValue()) != newLevel) {
            BlockState blockState = (BlockState)state.setValue((Property)FeedingTroughBlock.LEVEL, (Comparable)Integer.valueOf(newLevel));
            world.setBlockAndUpdate(pos, blockState);
        }
    }

    private boolean playersAround(Level world, BlockPos pos) {
        AABB lookupArea = new AABB((double)(pos.getX() - 5), (double)(pos.getY() - 2), (double)(pos.getZ() - 5), (double)(pos.getX() + 5), (double)(pos.getY() + 2), (double)(pos.getZ() + 5));
        List playersInArea = world.getEntitiesOfClass(Player.class, lookupArea, e -> true);
        return !playersInArea.isEmpty();
    }

    public void gatherExperienceOrbs(Level world, BlockPos pos) {
        if (this.playersAround(world, pos)) {
            return;
        }
        AABB lookupArea = new AABB((double)(pos.getX() - 2), (double)(pos.getY() - 2), (double)(pos.getZ() - 2), (double)(pos.getX() + 2), (double)(pos.getY() + 2), (double)(pos.getZ() + 2));
        List experienceOrbEntities = world.getEntitiesOfClass(ExperienceOrb.class, lookupArea, e -> true);
        if (experienceOrbEntities.isEmpty()) {
            return;
        }
        experienceOrbEntities.forEach(orb -> {
            this.storedExp += orb.getValue();
            orb.remove(Entity.RemovalReason.DISCARDED);
        });
    }

    public void dropStoredXp(Level world, Player playerEntity) {
        if (this.storedExp == 0) {
            return;
        }
        ExperienceOrb entity = new ExperienceOrb(world, playerEntity.getX(), playerEntity.getY() + 0.5, playerEntity.getZ(), this.storedExp);
        world.addFreshEntity((Entity)entity);
        this.storedExp = 0;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new FeedingTroughScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        this.storedExp = nbt.getInt("StoredExp");
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        nbt.putInt("StoredExp", this.storedExp);
    }
}

