/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.utils.Utils;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class TagInheritance {
    private final Options<Item> itemOptions;
    private final Options<Block> blockOptions;

    public TagInheritance(Mode itemMode, Map<TagKey<Item>, Set<Pattern>> itemInheritance, Mode blockMode, Map<TagKey<Block>, Set<Pattern>> blockInheritance) {
        this.itemOptions = new Options(itemMode, itemInheritance);
        this.blockOptions = new Options(blockMode, blockInheritance);
    }

    public boolean apply(VanillaTagWrapper<Item> itemTags, VanillaTagWrapper<Block> blockTags, List<? extends UnificationLookup> unificationLookups) {
        HashMultimap changedItemTags = HashMultimap.create();
        HashMultimap changedBlockTags = HashMultimap.create();
        Set<TagRelation> relations = this.resolveRelations(unificationLookups);
        if (relations.isEmpty()) {
            return false;
        }
        for (TagRelation relation : relations) {
            UnificationEntry<Item> targetItem = relation.targetItem;
            Holder.Reference<Item> targetItemHolder = targetItem.asHolderOrThrow();
            Holder<Block> targetBlockHolder = this.findTargetBlockHolder(blockTags, targetItem);
            ImmutableSet targetItemTags = (ImmutableSet)itemTags.getTags(targetItem).stream().map(rl -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl)).collect(ImmutableSet.toImmutableSet());
            for (UnificationEntry<Item> item : relation.items) {
                Set<ResourceLocation> appliedItemTags = this.applyItemTags(itemTags, (Holder<Item>)targetItemHolder, (Set<TagKey<Item>>)targetItemTags, item);
                changedItemTags.putAll(targetItem, appliedItemTags);
                if (targetBlockHolder == null) continue;
                Set<ResourceLocation> appliedBlockTags = this.applyBlockTags(blockTags, targetBlockHolder, (Set<TagKey<Item>>)targetItemTags, item);
                changedBlockTags.putAll(targetItem, appliedBlockTags);
            }
        }
        if (!changedBlockTags.isEmpty()) {
            changedBlockTags.asMap().forEach((target, tags) -> AlmostUnifiedCommon.LOGGER.info("[TagInheritance] Added '{}' to block tags {}", (Object)target.id(), tags));
        }
        if (!changedItemTags.isEmpty()) {
            changedItemTags.asMap().forEach((target, tags) -> AlmostUnifiedCommon.LOGGER.info("[TagInheritance] Added '{}' to item tags {}", (Object)target.id(), tags));
            return true;
        }
        return false;
    }

    @Nullable
    private Holder<Block> findTargetBlockHolder(VanillaTagWrapper<Block> tagMap, UnificationEntry<Item> targetItem) {
        Set<ResourceLocation> blockTags = tagMap.getTags(targetItem.id());
        if (blockTags.isEmpty()) {
            return null;
        }
        return BuiltInRegistries.BLOCK.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)targetItem.id()));
    }

    private Set<ResourceLocation> applyItemTags(VanillaTagWrapper<Item> vanillaTags, Holder<Item> targetItem, Set<TagKey<Item>> targetItemTags, UnificationEntry<Item> item) {
        Set<ResourceLocation> itemTags = vanillaTags.getTags(item);
        HashSet<ResourceLocation> changed = new HashSet<ResourceLocation>();
        for (ResourceLocation itemTag : itemTags) {
            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)itemTag);
            if (!this.itemOptions.shouldInherit((TagKey<Item>)tag, targetItemTags) || !TagInheritance.addToVanilla(targetItem, tag, vanillaTags)) continue;
            changed.add(itemTag);
        }
        return changed;
    }

    private Set<ResourceLocation> applyBlockTags(VanillaTagWrapper<Block> blockTagMap, Holder<Block> targetBlock, Set<TagKey<Item>> targetItemTags, UnificationEntry<Item> item) {
        Set<ResourceLocation> blockTags = blockTagMap.getTags(item.id());
        HashSet<ResourceLocation> changed = new HashSet<ResourceLocation>();
        for (ResourceLocation blockTag : blockTags) {
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)blockTag);
            if (!this.blockOptions.shouldInherit((TagKey<Block>)tag, targetItemTags) || !TagInheritance.addToVanilla(targetBlock, tag, blockTagMap)) continue;
            changed.add(blockTag);
        }
        return changed;
    }

    private static <T> boolean addToVanilla(Holder<T> holder, TagKey<T> tag, VanillaTagWrapper<T> vanillaTags) {
        Collection<Holder<T>> tagHolders = vanillaTags.get(tag);
        if (tagHolders.contains(holder)) {
            return false;
        }
        vanillaTags.add(tag.location(), holder);
        return true;
    }

    private Set<TagRelation> resolveRelations(Collection<? extends UnificationLookup> unificationLookups) {
        HashSet<TagRelation> relations = new HashSet<TagRelation>();
        for (UnificationLookup unificationLookup : unificationLookups) {
            for (TagKey<Item> unifyTag : unificationLookup.getTags()) {
                Set<UnificationEntry<Item>> items;
                UnificationEntry<Item> target;
                Collection<UnificationEntry<Item>> itemsByTag;
                if (this.itemOptions.skipForInheritance(unifyTag) && this.blockOptions.skipForInheritance(unifyTag) || Utils.allSameNamespace(itemsByTag = unificationLookup.getTagEntries(unifyTag)) || (target = unificationLookup.getTagTargetItem(unifyTag)) == null || (items = this.removeTargetItem(itemsByTag, target)).isEmpty()) continue;
                relations.add(new TagRelation(unifyTag, target, items));
            }
        }
        return relations;
    }

    private Set<UnificationEntry<Item>> removeTargetItem(Collection<UnificationEntry<Item>> holders, UnificationEntry<Item> target) {
        HashSet<UnificationEntry<Item>> result = new HashSet<UnificationEntry<Item>>(holders.size());
        for (UnificationEntry<Item> holder : holders) {
            if (holder.equals(target)) continue;
            result.add(holder);
        }
        return result;
    }

    private record Options<T>(Mode mode, Map<TagKey<T>, Set<Pattern>> inheritance) {
        public boolean skipForInheritance(TagKey<Item> tag) {
            String tagStr = tag.location().toString();
            boolean modeResult = this.mode == Mode.ALLOW;
            for (Set<Pattern> patterns : this.inheritance.values()) {
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(tagStr).matches()) continue;
                    return !modeResult;
                }
            }
            return modeResult;
        }

        public boolean shouldInherit(TagKey<T> inheritanceTag, Collection<TagKey<Item>> targetItemTags) {
            Set<Pattern> patterns = this.inheritance.getOrDefault(inheritanceTag, Set.of());
            boolean result = this.checkPatterns(targetItemTags, patterns);
            return this.mode == Mode.ALLOW ? result : !result;
        }

        private boolean checkPatterns(Collection<TagKey<Item>> tags, Collection<Pattern> patterns) {
            for (Pattern pattern : patterns) {
                for (TagKey<Item> tag : tags) {
                    if (!pattern.matcher(tag.location().toString()).matches()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum Mode {
        ALLOW,
        DENY;

    }

    private record TagRelation(TagKey<Item> tag, UnificationEntry<Item> targetItem, Set<UnificationEntry<Item>> items) {
    }
}

