/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.loot;

import com.autovw.advancednetherite.common.item.AdvancedPickaxeItem;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModTags;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class OreDropsLootModifier
extends LootModifier {
    public static final MapCodec<OreDropsLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> OreDropsLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, OreDropsLootModifier::new));

    public OreDropsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        BlockState blockState = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (tool != null && blockState != null && ConfigHelper.get().getCommon().getAdditionalDrops().enableAdditionalOreDrops()) {
            Block block = blockState.getBlock();
            RandomSource random = context.getRandom();
            if (!(tool.getItem() instanceof AdvancedPickaxeItem) || EnchantmentHelper.hasTag((ItemStack)tool, ModTags.PREVENTS_ADDITIONAL_ORE_DROPS)) {
                return generatedLoot;
            }
            if ((block == Blocks.IRON_ORE || block == Blocks.DEEPSLATE_IRON_ORE) && tool.is(ModTags.DROPS_ADDITIONAL_IRON) && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalRawIronDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.RAW_IRON, random.nextIntBetweenInclusive(1, 2)));
            }
            if ((block == Blocks.GOLD_ORE || block == Blocks.DEEPSLATE_GOLD_ORE) && tool.is(ModTags.DROPS_ADDITIONAL_GOLD) && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalRawGoldDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.RAW_GOLD, random.nextIntBetweenInclusive(1, 1)));
            }
            if ((block == Blocks.EMERALD_ORE || block == Blocks.DEEPSLATE_EMERALD_ORE) && tool.is(ModTags.DROPS_ADDITIONAL_EMERALD) && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalEmeraldDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.EMERALD, random.nextIntBetweenInclusive(1, 1)));
            }
            if ((block == Blocks.DIAMOND_ORE || block == Blocks.DEEPSLATE_DIAMOND_ORE) && tool.is(ModTags.DROPS_ADDITIONAL_DIAMOND) && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalDiamondDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.DIAMOND, random.nextIntBetweenInclusive(1, 1)));
            }
            if (block == Blocks.NETHER_GOLD_ORE && tool.is(ModTags.DROPS_ADDITIONAL_GOLD) && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalGoldNuggetDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.GOLD_NUGGET, random.nextIntBetweenInclusive(1, 3)));
            }
        }
        return generatedLoot;
    }

    public MapCodec<OreDropsLootModifier> codec() {
        return CODEC;
    }
}

