/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.item;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.common.AdvancedUtil;
import com.autovw.advancednetherite.config.ConfigHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedAxeItem
extends AxeItem {
    private final Tier tier;

    public AdvancedAxeItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
        this.tier = tier;
    }

    @Internal
    public AdvancedAxeItem(Tier tier, float attackDamage, float attackSpeed) {
        this(tier, new Item.Properties().attributes(AdvancedAxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)).fireResistant());
    }

    public void addTooltips(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flag) {
    }

    public ChatFormatting customDurabilityBarColor(ItemStack stack) {
        return null;
    }

    @Internal
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (ConfigHelper.get().getClient().showTooltips()) {
            this.addTooltips(stack, context, tooltip, flag);
        }
    }

    @Internal
    public int getBarColor(ItemStack stack) {
        int originalColor = super.getBarColor(stack);
        if (this.customDurabilityBarColor(stack) != null && ConfigHelper.get().getClient().matchingDurabilityBars()) {
            return Objects.requireNonNull(this.customDurabilityBarColor(stack).getColor());
        }
        return AdvancedUtil.getDurabilityBarColor(originalColor, stack);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        float originalSpeed = super.getDestroySpeed(stack, state);
        return AdvancedUtil.getDestroySpeed(originalSpeed, stack, state);
    }
}

