/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.common.AdvancedUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;

@EventBusSubscriber(modid="advancednetherite", bus=EventBusSubscriber.Bus.GAME)
@Internal
public class EventHandler {
    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        Player player = event.getPlayer();
        EnderMan enderMan = event.getEntity();
        if (player.isCreative()) {
            return;
        }
        if (AdvancedUtil.isWearingEndermanPassiveArmor(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        LivingEntity target = event.getOriginalAboutToBeSetTarget();
        LivingEntity attacker = event.getEntity();
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        if (attacker.getLastHurtByMob() == target) {
            return;
        }
        if (attacker instanceof Phantom) {
            Phantom phantom = (Phantom)attacker;
            if (AdvancedUtil.isWearingPhantomPassiveArmor(player)) {
                event.setNewAboutToBeSetTarget(null);
            }
        }
        if (attacker instanceof Piglin) {
            Piglin piglin = (Piglin)attacker;
            if (AdvancedUtil.isWearingPiglinPassiveArmor(player)) {
                event.setCanceled(true);
            }
        }
    }
}

