/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.crafting.FermentingRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFermentingBarrel;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileEntityFermentingBarrel
extends TileEntityBase
implements ISharingFluidHandler,
MenuProvider {
    public final FermentingBarrelMultiTank tanks = new FermentingBarrelMultiTank();
    public int currentProcessTime;
    private int lastInput;
    private int lastOutput;
    private int lastProcessTime;
    private int lastCompare;
    private RecipeHolder<FermentingRecipe> currentRecipe;

    public TileEntityFermentingBarrel(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.FERMENTING_BARREL.getTileEntityType(), pos, state);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        compound.putInt("ProcessTime", this.currentProcessTime);
        compound.put("tanks", (Tag)this.tanks.writeNBT(lookupProvider));
        if (this.currentRecipe != null) {
            compound.putString("currentRecipe", this.currentRecipe.id().toString());
        }
        super.writeSyncableNBT(compound, lookupProvider, type);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        this.currentProcessTime = compound.getInt("ProcessTime");
        if (compound.contains("tanks")) {
            this.tanks.readNBT(lookupProvider, compound.getCompound("tanks"));
        }
        if (compound.contains("currentRecipe")) {
            this.currentRecipe = ActuallyAdditionsAPI.FERMENTING_RECIPES.stream().filter(recipe -> recipe.id().toString().equals(compound.getString("currentRecipe"))).findFirst().orElse(null);
        }
        super.readSyncableNBT(compound, lookupProvider, type);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFermentingBarrel) {
            TileEntityFermentingBarrel tile = (TileEntityFermentingBarrel)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFermentingBarrel) {
            int compare;
            TileEntityFermentingBarrel tile = (TileEntityFermentingBarrel)t;
            tile.serverTick();
            if (tile.currentRecipe == null) {
                if (tile.ticksElapsed % 20 == 0) {
                    tile.currentRecipe = ActuallyAdditionsAPI.FERMENTING_RECIPES.stream().filter(recipe -> ((FermentingRecipe)recipe.value()).matches(tile.tanks.getFluidInTank(0), tile.tanks.getFluidInTank(1))).findFirst().orElse(null);
                }
            } else {
                FermentingRecipe recipe2 = (FermentingRecipe)tile.currentRecipe.value();
                if (tile.tanks.getFluidInTank(0).getAmount() >= recipe2.getInput().getAmount() && tile.tanks.getFluidInTank(0).getFluid().isSame(recipe2.getInput().getFluid()) && (tile.tanks.getFluidInTank(1).getFluid().isSame(recipe2.getOutput().getFluid()) || tile.tanks.getFluidInTank(1).isEmpty()) && recipe2.getOutput().getAmount() <= tile.tanks.getTankCapacity(1) - tile.tanks.getFluidInTank(1).getAmount()) {
                    ++tile.currentProcessTime;
                    if (tile.currentProcessTime >= recipe2.getTime()) {
                        tile.currentProcessTime = 0;
                        tile.tanks.outputTank.fill(recipe2.getOutput().copy(), IFluidHandler.FluidAction.EXECUTE);
                        tile.tanks.inputTank.getFluid().shrink(recipe2.getInput().getAmount());
                    }
                } else {
                    tile.currentProcessTime = 0;
                    tile.currentRecipe = null;
                }
            }
            if ((compare = tile.getComparatorStrength()) != tile.lastCompare) {
                tile.lastCompare = compare;
                tile.setChanged();
            }
            if ((tile.tanks.getFluidInTank(0).getAmount() != tile.lastInput || tile.tanks.getFluidInTank(1).getAmount() != tile.lastOutput || tile.currentProcessTime != tile.lastProcessTime) && tile.sendUpdateWithInterval()) {
                tile.lastProcessTime = tile.currentProcessTime;
                tile.lastInput = tile.tanks.getFluidInTank(0).getAmount();
                tile.lastOutput = tile.tanks.getFluidInTank(1).getAmount();
            }
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.tanks.inputTank.setFluid(((ActuallyComponents.FluidContents)componentInput.getOrDefault(ActuallyComponents.FLUID_A, (Object)ActuallyComponents.FluidContents.EMPTY)).get());
        this.tanks.outputTank.setFluid(((ActuallyComponents.FluidContents)componentInput.getOrDefault(ActuallyComponents.FLUID_B, (Object)ActuallyComponents.FluidContents.EMPTY)).get());
    }

    protected void collectImplicitComponents(@Nonnull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ActuallyComponents.FLUID_A, (Object)ActuallyComponents.FluidContents.of(this.tanks.inputTank.getFluid()));
        builder.set(ActuallyComponents.FLUID_B, (Object)ActuallyComponents.FluidContents.of(this.tanks.outputTank.getFluid()));
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.tanks.getFluidInTank(1).getAmount() / (float)this.tanks.getTankCapacity(1) * 15.0f;
        return (int)calc;
    }

    public int getProcessScaled(int i) {
        if (this.currentRecipe != null) {
            return this.currentProcessTime * i / ((FermentingRecipe)this.currentRecipe.value()).getTime();
        }
        return this.currentProcessTime * i / 100;
    }

    public int getOilTankScaled(int i) {
        return this.tanks.getFluidInTank(1).getAmount() * i / this.tanks.getTankCapacity(1);
    }

    public int getCanolaTankScaled(int i) {
        return this.tanks.getFluidInTank(0).getAmount() * i / this.tanks.getTankCapacity(0);
    }

    @Override
    public IFluidHandler getFluidHandler(Direction facing) {
        return this.tanks;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return this.tanks.getFluidInTank(1).getAmount();
    }

    @Override
    public boolean doesShareFluid() {
        return true;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return Direction.values();
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.fermenting_barrel");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player p_createMenu_3_) {
        return new ContainerFermentingBarrel(windowId, playerInventory, this);
    }

    public static boolean validInput(FluidStack stack) {
        return TileEntityFermentingBarrel.getRecipeForInput(stack).isPresent();
    }

    public static Optional<RecipeHolder<FermentingRecipe>> getRecipeForInput(FluidStack stack) {
        return ActuallyAdditionsAPI.FERMENTING_RECIPES.stream().filter(recipe -> ((FermentingRecipe)recipe.value()).matches(stack)).findFirst();
    }

    public static class FermentingBarrelMultiTank
    implements IFluidHandler {
        private final int capacity = 2000;
        public FluidTank inputTank = new FluidTank(2000);
        public FluidTank outputTank = new FluidTank(2000);

        public int getTanks() {
            return 2;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? this.inputTank.getFluid() : this.outputTank.getFluid();
        }

        public int getTankCapacity(int tank) {
            return 2000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0 && TileEntityFermentingBarrel.validInput(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || !TileEntityFermentingBarrel.validInput(resource)) {
                return 0;
            }
            if (action.simulate()) {
                if (this.inputTank.isEmpty()) {
                    return Math.min(2000, resource.getAmount());
                }
                return Math.min(2000 - this.inputTank.getFluid().getAmount(), resource.getAmount());
            }
            if (this.inputTank.isEmpty()) {
                this.inputTank.fill(new FluidStack(resource.getFluidHolder(), Math.min(2000, resource.getAmount())), IFluidHandler.FluidAction.EXECUTE);
                return this.inputTank.getFluid().getAmount();
            }
            int filledAmt = 2000 - this.inputTank.getFluid().getAmount();
            if (resource.getAmount() < filledAmt) {
                this.inputTank.getFluid().grow(resource.getAmount());
                filledAmt = resource.getAmount();
            } else {
                this.inputTank.getFluid().setAmount(2000);
            }
            if (filledAmt > 0) {
                // empty if block
            }
            return filledAmt;
        }

        public CompoundTag writeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag inputNBT = new CompoundTag();
            this.inputTank.writeToNBT(lookupProvider, inputNBT);
            CompoundTag outputNBT = new CompoundTag();
            this.outputTank.writeToNBT(lookupProvider, outputNBT);
            CompoundTag nbt = new CompoundTag();
            nbt.put("inputTank", (Tag)inputNBT);
            nbt.put("outputTank", (Tag)outputNBT);
            return nbt;
        }

        public void readNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.inputTank.readFromNBT(lookupProvider, nbt.getCompound("inputTank"));
            this.outputTank.readFromNBT(lookupProvider, nbt.getCompound("outputTank"));
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || resource.getFluid() != this.outputTank.getFluid().getFluid()) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int drained = maxDrain;
            if (this.outputTank.getFluid().getAmount() < drained) {
                drained = this.outputTank.getFluid().getAmount();
            }
            FluidStack stack = new FluidStack(this.outputTank.getFluid().getFluidHolder(), drained);
            if (action.execute() && drained > 0) {
                this.outputTank.getFluid().shrink(drained);
            }
            return stack;
        }
    }
}

