/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotOutput;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPoweredFurnace;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class ContainerFurnaceDouble
extends AbstractContainerMenu {
    public final TileEntityPoweredFurnace furnace;

    public ContainerFurnaceDouble(int windowId, Inventory inventory, TileEntityPoweredFurnace tile) {
        super(ActuallyContainers.FURNACE_DOUBLE_CONTAINER.get(), windowId);
        int i;
        this.furnace = tile;
        this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.furnace.inv, 0, 51, 21));
        this.addSlot((Slot)new SlotOutput(this.furnace.inv, 1, 51, 69));
        this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.furnace.inv, 2, 109, 21));
        this.addSlot((Slot)new SlotOutput(this.furnace.inv, 3, 108, 69));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 97 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 155));
        }
    }

    public static ContainerFurnaceDouble fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerFurnaceDouble(windowId, inv, (TileEntityPoweredFurnace)Objects.requireNonNull(inv.player.level().getBlockEntity(data.readBlockPos())));
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int slot) {
        int inventoryStart = 4;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot != null && theSlot.hasItem()) {
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (slot == 1 || slot == 3) {
                if (!this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, true)) {
                    return ItemStack.EMPTY;
                }
                theSlot.onQuickCraft(newStack, currentStack);
            } else if (slot >= inventoryStart) {
                RecipeHolder recipeHolder = this.furnace.getLevel().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(newStack), this.furnace.getLevel()).orElse(null);
                if (recipeHolder == null) {
                    return ItemStack.EMPTY;
                }
                ItemStack recipeOutput = ((SmeltingRecipe)recipeHolder.value()).getResultItem((HolderLookup.Provider)player.level().registryAccess());
                if (!recipeOutput.isEmpty() ? !this.moveItemStackTo(newStack, 0, 1, false) && !this.moveItemStackTo(newStack, 2, 3, false) : (slot >= inventoryStart && slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false))) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.furnace.canPlayerUse(player);
    }
}

