/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.blockhuds;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.mod.blocks.blockhuds.IBlockHud;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFarmer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FarmerHud
implements IBlockHud {
    @Override
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
        if (!(rayCast instanceof BlockHitResult) || minecraft.level == null) {
            return;
        }
        BlockEntity tile = minecraft.level.getBlockEntity(((BlockHitResult)rayCast).getBlockPos());
        if (tile instanceof TileEntityFarmer) {
            TileEntityFarmer farmer = (TileEntityFarmer)tile;
            guiGraphics.drawString(minecraft.font, (Component)Component.translatable((String)"info.actuallyadditions.farmer.area", (Object[])new Object[]{farmer.getArea(), farmer.getArea()}), (int)((float)resolution.getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)resolution.getGuiScaledHeight() / 2.0f - 0.0f), 0xFFFFFF);
            MutableComponent message = !stack.isEmpty() && stack.getItem() == CommonConfig.Other.farmerConfigureItem ? Component.translatable((String)"info.actuallyadditions.farmer.validItem").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"info.actuallyadditions.farmer.invalidItem", (Object[])new Object[]{Component.translatable((String)CommonConfig.Other.farmerConfigureItem.asItem().getDescriptionId()).getString()}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
            guiGraphics.drawString(minecraft.font, (Component)message, (int)((float)minecraft.getWindow().getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)minecraft.getWindow().getGuiScaledHeight() / 2.0f + 15.0f), 0xFFFFFF);
        }
    }
}

