/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;

public class CapHelper {
    @Nonnull
    public static Optional<IItemHandler> getItemHandler(@Nonnull Level level, @Nonnull BlockPos pos, @Nullable Direction side) {
        BlockEntity blockEntity;
        BlockState blockState = level.getBlockState(pos);
        if (blockState.hasBlockEntity() && (blockEntity = level.getBlockEntity(pos)) != null) {
            return Optional.ofNullable((IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, level.getBlockState(pos), blockEntity, (Object)side));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<IItemHandler> getItemHandler(ItemStack stack) {
        return Optional.ofNullable((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM));
    }

    @Nonnull
    public static Optional<IEnergyStorage> getEnergyStorage(@Nonnull ItemStack stack) {
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM));
    }
}

