/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayFluids;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TileEntityPhantomLiquiface
extends TileEntityPhantomface
implements ISharingFluidHandler {
    public TileEntityPhantomLiquiface(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PHANTOM_LIQUIFACE.getTileEntityType(), pos, state);
        this.type = BlockPhantom.Type.LIQUIFACE;
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomLiquiface) {
            TileEntityPhantomLiquiface tile = (TileEntityPhantomLiquiface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomLiquiface) {
            TileEntityPhantomLiquiface tile = (TileEntityPhantomLiquiface)t;
            tile.serverTick();
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        BlockEntity tile;
        if (super.isBoundThingInRange() && (tile = this.level.getBlockEntity(this.getBoundPosition())) != null && !(tile instanceof TileEntityLaserRelayFluids)) {
            for (Direction facing : Direction.values()) {
                if (this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBoundPosition(), (Object)facing) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IFluidHandler getFluidHandler(Direction facing) {
        BlockEntity tile;
        if (this.isBoundThingInRange() && (tile = this.level.getBlockEntity(this.getBoundPosition())) != null) {
            return (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBoundPosition(), (Object)facing);
        }
        return null;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean doesShareFluid() {
        return true;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return Direction.values();
    }
}

