/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.TriState;

public class NetherWartFarmerBehavior
implements IFarmerBehavior {
    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, Level world, BlockPos pos, IFarmer farmer) {
        int use = 500;
        if (farmer.getEnergy() >= use && seed.is(Items.NETHER_WART)) {
            BlockState belowState = world.getBlockState(pos.below());
            TriState result = belowState.canSustainPlant((BlockGetter)world, pos, Direction.UP, Blocks.NETHER_WART.defaultBlockState());
            BlockState wartState = Blocks.NETHER_WART.defaultBlockState();
            if (result.isTrue() || wartState.canSurvive((LevelReader)world, pos)) {
                world.setBlock(pos, wartState, 2);
                farmer.extractEnergy(use);
                return FarmerResult.SUCCESS;
            }
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(ServerLevel world, BlockPos pos, IFarmer farmer) {
        boolean toInput;
        List drops;
        BlockState state;
        int use = 500;
        if (farmer.getEnergy() >= use && (state = world.getBlockState(pos)).getBlock() instanceof NetherWartBlock && (Integer)state.getValue((Property)BlockStateProperties.AGE_3) >= 3 && !(drops = state.getDrops(new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY))).isEmpty() && ((toInput = farmer.canAddToSeeds(drops)) || farmer.canAddToOutput(drops))) {
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            if (toInput) {
                farmer.addToSeeds(drops);
            } else {
                farmer.addToOutput(drops);
            }
            farmer.extractEnergy(use);
            return FarmerResult.SUCCESS;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 3;
    }
}

