/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;

public class ItemSolidifiedExperience
extends ItemBase {
    public static final int SOLID_XP_AMOUNT = 8;

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            int amount;
            if (!player.isShiftKeyDown()) {
                amount = 8;
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
            } else {
                amount = 8 * stack.getCount();
                if (!player.isCreative()) {
                    stack.setCount(0);
                }
            }
            if (((Boolean)CommonConfig.Other.SOLID_XP_ALWAYS_ORBS.get()).booleanValue() || player instanceof FakePlayer) {
                ExperienceOrb orb = new ExperienceOrb(world, player.getX() + 0.5, player.getY() + 0.5, player.getZ() + 0.5, amount);
                orb.getPersistentData().putBoolean("actuallyadditionsFromSolidified", true);
                world.addFreshEntity((Entity)orb);
            } else {
                player.giveExperiencePoints(amount);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

