/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.aces_spell_utils.events;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import net.acetheeldritchking.aces_spell_utils.AcesSpellUtils;
import net.acetheeldritchking.aces_spell_utils.registries.ASAttributeRegistry;
import net.acetheeldritchking.aces_spell_utils.utils.ASTags;
import net.acetheeldritchking.aces_spell_utils.utils.AcesSpellUtilsConfig;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class AcesSpellUtilsServerEvents {
    @SubscribeEvent
    public static void manaStealEvent(LivingDamageEvent.Post event) {
        Entity sourceEntity = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        Entity directEntity = event.getSource().getDirectEntity();
        if (!(sourceEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)sourceEntity;
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        if (directEntity == null) {
            return;
        }
        if (!directEntity.getType().is(ASTags.MANA_STEAL_WHITELIST) && !directEntity.is((Entity)serverPlayer)) {
            return;
        }
        AttributeInstance hasManaSteal = serverPlayer.getAttribute(ASAttributeRegistry.MANA_STEAL);
        if (hasManaSteal == null) {
            return;
        }
        float manaStealAttr = (float)serverPlayer.getAttributeValue(ASAttributeRegistry.MANA_STEAL);
        int maxAttackerMana = (int)serverPlayer.getAttributeValue((Holder)AttributeRegistry.MAX_MANA);
        MagicData attackerPlayerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        if (manaStealAttr <= 0.0f) {
            return;
        }
        int addMana = (int)Math.min(manaStealAttr * event.getOriginalDamage() + attackerPlayerMagicData.getMana(), (float)maxAttackerMana);
        attackerPlayerMagicData.setMana((float)addMana);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(attackerPlayerMagicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (AcesSpellUtilsConfig.manaStealDrain && target instanceof ServerPlayer) {
            ServerPlayer serverTargetPlayer = (ServerPlayer)target;
            int maxTargetMana = (int)serverTargetPlayer.getAttributeValue((Holder)AttributeRegistry.MAX_MANA);
            MagicData targetPlayerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverTargetPlayer);
            int subMana = (int)Math.min(manaStealAttr * event.getOriginalDamage() - attackerPlayerMagicData.getMana(), (float)maxAttackerMana);
            if (maxTargetMana <= 0) {
                return;
            }
            targetPlayerMagicData.setMana((float)subMana);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(targetPlayerMagicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void manaRendEvent(LivingIncomingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        Entity directEntity = event.getSource().getDirectEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        if (directEntity == null) {
            return;
        }
        if (!directEntity.getType().is(ASTags.MANA_REND_WHITELIST) && !directEntity.is(attacker)) {
            return;
        }
        AttributeInstance hasManaRend = livingEntity.getAttribute(ASAttributeRegistry.MANA_REND);
        AttributeInstance targetHasMana = victim.getAttribute((Holder)AttributeRegistry.MAX_MANA);
        if (hasManaRend == null || targetHasMana == null) {
            return;
        }
        double manaRendAttr = livingEntity.getAttributeValue(ASAttributeRegistry.MANA_REND);
        double victimMaxMana = victim.getAttributeValue((Holder)AttributeRegistry.MAX_MANA);
        double victimBaseMana = victim.getAttributeBaseValue((Holder)AttributeRegistry.MAX_MANA);
        if (manaRendAttr <= 0.0 || victimMaxMana <= 0.0) {
            return;
        }
        double bonusManaFromBase = victimMaxMana / victimBaseMana;
        double step = bonusManaFromBase * 0.01;
        double totalExtraDamagerPercent = 1.0 + step * manaRendAttr;
        event.setAmount((float)((double)event.getAmount() * totalExtraDamagerPercent));
        AcesSpellUtils.LOGGER.debug("Old Damage amount: " + event.getOriginalAmount());
        AcesSpellUtils.LOGGER.debug("New Damage amount: " + event.getAmount());
    }

    @SubscribeEvent
    public static void goliathSlayerEvent(LivingIncomingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        AttributeInstance hasGoliathSlayer = livingEntity.getAttribute(ASAttributeRegistry.GOLIATH_SLAYER);
        if (hasGoliathSlayer == null) {
            return;
        }
        double goliathSlayerAttr = livingEntity.getAttributeValue(ASAttributeRegistry.GOLIATH_SLAYER);
        if (goliathSlayerAttr <= 0.0) {
            return;
        }
        if (!victim.getType().is(ASTags.BOSS_LIKE_ENTITES)) {
            return;
        }
        float baseDamage = event.getOriginalAmount();
        float bonusDamage = (float)((double)baseDamage * goliathSlayerAttr);
        float totalDamage = baseDamage + bonusDamage;
        event.setAmount(totalDamage);
        AcesSpellUtils.LOGGER.debug("OG Damage: " + baseDamage);
        AcesSpellUtils.LOGGER.debug("Bonus Damage: " + bonusDamage);
        AcesSpellUtils.LOGGER.debug("Total Damage: " + event.getAmount());
    }

    @SubscribeEvent
    public static void hungerStealEvent(LivingDamageEvent.Pre event) {
        Entity sourceEntity = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        if (!(sourceEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)sourceEntity;
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        AttributeInstance hasHungerSteal = serverPlayer.getAttribute(ASAttributeRegistry.HUNGER_STEAL);
        if (hasHungerSteal == null) {
            return;
        }
        double hungerStealAttr = serverPlayer.getAttributeValue(ASAttributeRegistry.HUNGER_STEAL);
        if (hungerStealAttr <= 0.0) {
            return;
        }
        FoodData playerFood = serverPlayer.getFoodData();
        int foodLevel = playerFood.getFoodLevel();
        int addFood = (int)Math.max(hungerStealAttr + (double)foodLevel, (double)foodLevel);
        playerFood.setFoodLevel(addFood);
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            FoodData targetFood = targetPlayer.getFoodData();
            int targetFoodLevel = playerFood.getFoodLevel();
            int subFood = (int)Math.min(hungerStealAttr - (double)targetFoodLevel, (double)targetFoodLevel);
            targetFood.setFoodLevel(subFood);
        }
    }

    @SubscribeEvent
    public static void spellResPenetrationEvent(LivingIncomingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        AttributeInstance hasSpellResPen = livingEntity.getAttribute(ASAttributeRegistry.SPELL_RES_PENETRATION);
        if (hasSpellResPen == null) {
            return;
        }
        double spellResPenAttr = livingEntity.getAttributeValue(ASAttributeRegistry.SPELL_RES_PENETRATION);
        double spellResAttr = victim.getAttributeValue((Holder)AttributeRegistry.SPELL_RESIST);
        if (spellResPenAttr <= 0.0) {
            return;
        }
        if (event.getSource() instanceof SpellDamageSource) {
            float baseDamage = event.getOriginalAmount();
            float bonusDamage = (float)((double)baseDamage * (spellResPenAttr + spellResAttr));
            float totalDamage = baseDamage + bonusDamage;
            event.setAmount(totalDamage);
            AcesSpellUtils.LOGGER.debug("OG Damage: " + baseDamage);
            AcesSpellUtils.LOGGER.debug("Bonus Damage: " + bonusDamage);
            AcesSpellUtils.LOGGER.debug("Total Damage: " + event.getAmount());
        }
    }

    @SubscribeEvent
    public static void evasiveEvent(LivingIncomingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (!(victim instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = victim;
        AttributeInstance hasEvasive = livingEntity.getAttribute(ASAttributeRegistry.EVASIVE);
        if (hasEvasive == null) {
            return;
        }
        double evasiveAttr = livingEntity.getAttributeValue(ASAttributeRegistry.EVASIVE);
        if (evasiveAttr <= 0.0) {
            return;
        }
        int postInvulTicks = event.getContainer().getPostAttackInvulnerabilityTicks();
        event.setInvulnerabilityTicks(postInvulTicks *= (int)evasiveAttr);
        AcesSpellUtils.LOGGER.debug("I Frames: " + livingEntity.invulnerableTime);
        if (!livingEntity.level().isClientSide()) {
            MagicManager.spawnParticles((Level)livingEntity.level(), (ParticleOptions)ParticleTypes.SMOKE, (double)livingEntity.getX(), (double)livingEntity.getY(), (double)livingEntity.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
        }
    }
}

