/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.aces_spell_utils.utils.boss_music;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.acetheeldritchking.aces_spell_utils.entity.mobs.GenericBossEntity;
import net.acetheeldritchking.aces_spell_utils.utils.boss_music.BossSoundInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class BossMusicManager {
    @Nullable
    private static BossMusicManager INSTANCE;
    static final SoundSource SOUND_SOURCE;
    GenericBossEntity genericBoss;
    final SoundManager manager;
    BossSoundInstance bossMusic;
    BossSoundInstance bossTransitionMusic;
    BossSoundInstance bossAltMusic;
    int phaseForTransition;
    int phaseForMusicChange;
    boolean hasCustomMusic;
    GenericBossEntity.Phase phase;
    Set<BossSoundInstance> layers = new HashSet<BossSoundInstance>();
    boolean finishedPlaying = false;

    private BossMusicManager(GenericBossEntity boss) {
        this.genericBoss = boss;
        this.manager = Minecraft.getInstance().getSoundManager();
        this.phase = GenericBossEntity.Phase.values()[boss.getPhase()];
        this.phaseForTransition = boss.usePhaseAsTransition();
        this.phaseForMusicChange = boss.usePhaseForMusicChange();
        this.hasCustomMusic = boss.hasCustomMusic();
        this.bossMusic = new BossSoundInstance(this.getBossMusic(), SOUND_SOURCE, true);
        this.bossTransitionMusic = new BossSoundInstance(this.getTransitionMusic(), SOUND_SOURCE, true);
        this.bossAltMusic = new BossSoundInstance(this.getOtherPhaseMusic(), SOUND_SOURCE, true);
        this.init();
    }

    private void init() {
        this.manager.stop(null, SoundSource.MUSIC);
        if (this.hasCustomMusic) {
            switch (this.phase) {
                case FirstPhase: {
                    this.addLayer(this.bossMusic);
                    break;
                }
                case SecondPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 1) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 1) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case ThirdPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 2) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 2) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case FourthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 3) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 3) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case FifthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 4) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 4) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case SixthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 5) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 5) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case SeventhPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 6) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 6) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case EighthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 7) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 7) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case NinethPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 8) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 8) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case TenthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 9) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 9) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case EleventhPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 10) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 10) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                case TwelfthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && this.genericBoss.usePhaseAsTransition() == 11) {
                        this.addLayer(this.bossTransitionMusic);
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || this.genericBoss.usePhaseForMusicChange() != 11) break;
                    this.addLayer(this.bossAltMusic);
                    break;
                }
                default: {
                    if (this.genericBoss.changeMusicOnPhaseChange()) break;
                    this.addLayer(this.bossMusic);
                }
            }
        }
    }

    public SoundEvent getBossMusic() {
        return this.genericBoss.getBossMusic();
    }

    public SoundEvent getTransitionMusic() {
        return this.genericBoss.getTransitionMusic();
    }

    public SoundEvent getOtherPhaseMusic() {
        return this.genericBoss.getOtherPhaseMusic();
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        if (INSTANCE != null && !Minecraft.getInstance().isPaused()) {
            INSTANCE.tick();
        }
    }

    public static void createOrResumeInstance(GenericBossEntity boss) {
        if (INSTANCE == null || INSTANCE.isDonePlaying()) {
            INSTANCE = new BossMusicManager(boss);
        } else {
            INSTANCE.triggerResumeMusic(boss);
        }
    }

    public static void stop(GenericBossEntity boss) {
        if (INSTANCE != null && BossMusicManager.INSTANCE.genericBoss.getUUID().equals(boss.getUUID())) {
            INSTANCE.stopLayers();
            BossMusicManager.INSTANCE.finishedPlaying = true;
        }
    }

    private void tick() {
        if (this.isDonePlaying() || this.finishedPlaying) {
            return;
        }
        if (this.genericBoss.isDeadOrDying() || this.genericBoss.isRemoved()) {
            this.stopLayers();
            this.finishedPlaying = true;
            return;
        }
        GenericBossEntity.Phase bossPhase = GenericBossEntity.Phase.values()[this.genericBoss.getPhase()];
        int transitionPhase = this.genericBoss.usePhaseAsTransition();
        int changePhase = this.genericBoss.usePhaseForMusicChange();
        if (this.genericBoss.hasCustomMusic()) {
            switch (bossPhase) {
                case FirstPhase: {
                    if (this.manager.isActive((SoundInstance)this.bossMusic)) break;
                    this.playFirstPhaseMusic();
                    break;
                }
                case SecondPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 1) {
                        if (this.phase == GenericBossEntity.Phase.SecondPhase) break;
                        this.phase = GenericBossEntity.Phase.SecondPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 1 || this.phase == GenericBossEntity.Phase.SecondPhase) break;
                    this.phase = GenericBossEntity.Phase.SecondPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case ThirdPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 2) {
                        if (this.phase == GenericBossEntity.Phase.ThirdPhase) break;
                        this.phase = GenericBossEntity.Phase.ThirdPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 2 || this.phase == GenericBossEntity.Phase.ThirdPhase) break;
                    this.phase = GenericBossEntity.Phase.ThirdPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case FourthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 3) {
                        if (this.phase == GenericBossEntity.Phase.FourthPhase) break;
                        this.phase = GenericBossEntity.Phase.FourthPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 3 || this.phase == GenericBossEntity.Phase.FourthPhase) break;
                    this.phase = GenericBossEntity.Phase.FourthPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case FifthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 4) {
                        if (this.phase == GenericBossEntity.Phase.FifthPhase) break;
                        this.phase = GenericBossEntity.Phase.FifthPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 4 || this.phase == GenericBossEntity.Phase.FifthPhase) break;
                    this.phase = GenericBossEntity.Phase.FifthPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case SixthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 5) {
                        if (this.phase == GenericBossEntity.Phase.SixthPhase) break;
                        this.phase = GenericBossEntity.Phase.SixthPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 5 || this.phase == GenericBossEntity.Phase.SixthPhase) break;
                    this.phase = GenericBossEntity.Phase.SixthPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case SeventhPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 6) {
                        if (this.phase == GenericBossEntity.Phase.SeventhPhase) break;
                        this.phase = GenericBossEntity.Phase.SeventhPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 6 || this.phase == GenericBossEntity.Phase.SeventhPhase) break;
                    this.phase = GenericBossEntity.Phase.SeventhPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case EighthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 7) {
                        if (this.phase == GenericBossEntity.Phase.EighthPhase) break;
                        this.phase = GenericBossEntity.Phase.EighthPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 7 || this.phase == GenericBossEntity.Phase.EighthPhase) break;
                    this.phase = GenericBossEntity.Phase.EighthPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case NinethPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 8) {
                        if (this.phase == GenericBossEntity.Phase.NinethPhase) break;
                        this.phase = GenericBossEntity.Phase.NinethPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 8 || this.phase == GenericBossEntity.Phase.NinethPhase) break;
                    this.phase = GenericBossEntity.Phase.NinethPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case TenthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 9) {
                        if (this.phase == GenericBossEntity.Phase.TenthPhase) break;
                        this.phase = GenericBossEntity.Phase.TenthPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 9 || this.phase == GenericBossEntity.Phase.TenthPhase) break;
                    this.phase = GenericBossEntity.Phase.TenthPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case EleventhPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 10) {
                        if (this.phase == GenericBossEntity.Phase.EleventhPhase) break;
                        this.phase = GenericBossEntity.Phase.EleventhPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 10 || this.phase == GenericBossEntity.Phase.EleventhPhase) break;
                    this.phase = GenericBossEntity.Phase.EleventhPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                case TwelfthPhase: {
                    if (this.genericBoss.changeMusicOnPhaseChange() && this.genericBoss.hasTransitionPhase() && transitionPhase == 11) {
                        if (this.phase == GenericBossEntity.Phase.TwelfthPhase) break;
                        this.phase = GenericBossEntity.Phase.TwelfthPhase;
                        this.stopLayers();
                        this.playTransitionPhaseMusic();
                        break;
                    }
                    if (!this.genericBoss.changeMusicOnPhaseChange() || changePhase != 11 || this.phase == GenericBossEntity.Phase.TwelfthPhase) break;
                    this.phase = GenericBossEntity.Phase.TwelfthPhase;
                    this.stopLayers();
                    this.playAltPhaseMusic();
                    break;
                }
                default: {
                    if (this.manager.isActive((SoundInstance)this.bossMusic) || this.genericBoss.changeMusicOnPhaseChange()) break;
                    this.playFirstPhaseMusic();
                }
            }
        }
    }

    private boolean isDonePlaying() {
        for (BossSoundInstance soundInstance : this.layers) {
            if (soundInstance.isStopped() || !this.manager.isActive((SoundInstance)soundInstance)) continue;
            return false;
        }
        return true;
    }

    private void addLayer(BossSoundInstance instance) {
        this.layers.stream().filter(sound -> sound.isStopped() || !this.manager.isActive((SoundInstance)sound)).toList().forEach(this.layers::remove);
        this.manager.play((SoundInstance)instance);
        this.layers.add(instance);
    }

    public void stopLayers() {
        this.layers.forEach(BossSoundInstance::triggerStop);
    }

    public static void hardStop() {
        if (INSTANCE != null) {
            BossMusicManager.INSTANCE.layers.forEach(arg_0 -> ((SoundManager)BossMusicManager.INSTANCE.manager).stop(arg_0));
            INSTANCE = null;
        }
    }

    public void triggerResumeMusic(GenericBossEntity boss) {
        if (boss.getUUID().equals(this.genericBoss.getUUID())) {
            this.genericBoss = boss;
        }
        if (this.genericBoss.isRemoved()) {
            this.layers.forEach(sound -> {
                if (!this.manager.isActive((SoundInstance)sound)) {
                    this.manager.play((SoundInstance)sound);
                }
            });
            this.finishedPlaying = false;
        }
    }

    private void playFirstPhaseMusic() {
        this.addLayer(this.bossMusic);
    }

    private void playTransitionPhaseMusic() {
        this.addLayer(this.bossTransitionMusic);
    }

    private void playAltPhaseMusic() {
        this.addLayer(this.bossAltMusic);
    }

    static {
        SOUND_SOURCE = SoundSource.RECORDS;
    }
}

