/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.mixin.lost_caves.client;

import com.yungnickyoung.minecraft.yungscavebiomes.client.render.sandstorm.SandstormFogRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    @Shadow
    private static float fogRed;
    @Shadow
    private static float fogGreen;
    @Shadow
    private static float fogBlue;
    @Unique
    private static final SandstormFogRenderer sandstormFogRenderer;

    @Inject(method={"setupFog"}, at={@At(value="TAIL")})
    private static void yungscavebiomes_handleLostCavesFogFabric(Camera camera, FogRenderer.FogMode mode, float renderDistance, boolean isVeryFoggy, float g, CallbackInfo ci) {
        sandstormFogRenderer.render(mode, renderDistance);
    }

    @Inject(method={"setupColor"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer;biomeChangedTime:J", ordinal=4, opcode=179, shift=At.Shift.AFTER)})
    private static void yungscavebiomes_setupLostCavesColorFabric(Camera camera, float f, ClientLevel clientLevel, int i2, float g, CallbackInfo ci) {
        if (sandstormFogRenderer.getFogLevel() > 0.0) {
            fogRed = (float)Mth.lerp((double)sandstormFogRenderer.getFogLevel(), (double)fogRed, (double)0.8f);
            fogGreen = (float)Mth.lerp((double)sandstormFogRenderer.getFogLevel(), (double)fogGreen, (double)0.5);
            fogBlue = (float)Mth.lerp((double)sandstormFogRenderer.getFogLevel(), (double)fogBlue, (double)0.15f);
        }
    }

    static {
        sandstormFogRenderer = new SandstormFogRenderer();
    }
}

