/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.mixin.lost_caves;

import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BiomeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.MobEffectModule;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.ISandstormServerDataProvider;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private static final int BUFFETED_EFFECT_DURATION = 100;
    @Unique
    private static final int BUFFETED_EFFECT_REAPPLY_THRESHOLD = 60;

    @Shadow
    public abstract boolean addEffect(MobEffectInstance var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void yungscavebiomes_buffetEntitiesInSandstorm(CallbackInfo ci) {
        MobEffectInstance buffetedEffect;
        ServerLevel serverLevel;
        Level level;
        if (YungsCaveBiomesCommon.CONFIG.lostCaves.enableSandstorms && this.isPlayer((Object)this) && !this.level().isClientSide && !this.isSpectator() && this.tickCount % 10 == 0 && (level = this.level()) instanceof ServerLevel && ((ISandstormServerDataProvider)(serverLevel = (ServerLevel)level)).getSandstormServerData().isSandstormActive() && this.level().getBiome(this.blockPosition()).is(BiomeModule.LOST_CAVES) && ((buffetedEffect = this.getEffect((Holder<MobEffect>)MobEffectModule.BUFFETED_EFFECT.getHolder())) == null || buffetedEffect.getDuration() < 60)) {
            this.addEffect(new MobEffectInstance(MobEffectModule.BUFFETED_EFFECT.getHolder(), 100, 0, false, false, true));
        }
    }

    @Unique
    private boolean isPlayer(Object object) {
        return object instanceof Player;
    }
}

