/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity;

import com.yungnickyoung.minecraft.yungscavebiomes.mixin.accessor.AbstractArrowAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.services.Services;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IcicleProjectileEntity
extends AbstractArrow {
    public IcicleProjectileEntity(EntityType<IcicleProjectileEntity> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(1.5);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        this.setSoundEvent(SoundEvents.GLASS_BREAK);
    }

    public IcicleProjectileEntity(Level level, LivingEntity shooter, ItemStack arrowItemStack, @Nullable ItemStack weaponItemStack) {
        super((EntityType)EntityTypeModule.ICICLE.get(), shooter, level, arrowItemStack, weaponItemStack);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        this.setSoundEvent(SoundEvents.GLASS_BREAK);
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)BlockModule.ICICLE.get());
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)BlockModule.ICICLE.get());
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        BlockState hitBlockState = this.level().getBlockState(blockHitResult.getBlockPos());
        hitBlockState.onProjectileHit(this.level(), hitBlockState, blockHitResult, (Projectile)this);
        Vec3 $$1 = blockHitResult.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement($$1);
        Vec3 $$2 = $$1.normalize().scale((double)0.05f);
        this.setPosRaw(this.getX() - $$2.x, this.getY() - $$2.y, this.getZ() - $$2.z);
        this.setCritArrow(false);
        this.setSoundEvent(SoundEvents.ARROW_HIT);
        ((AbstractArrowAccessor)((Object)this)).callResetPiercedEntities();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Services.PLATFORM.sendIcicleProjectileShatterS2CPacket(serverLevel, this.position());
        }
        this.playSound(SoundEvents.GLASS_BREAK, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.discard();
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Services.PLATFORM.sendIcicleProjectileShatterS2CPacket(serverLevel, this.position());
        }
    }

    public void tick() {
        super.tick();
    }
}

