/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungscavebiomes.module.TrimPatternsModule;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DebugSpawnArmorTrimsCommand {
    private static final Map<Pair<Holder<ArmorMaterial>, EquipmentSlot>, Item> MATERIAL_AND_SLOT_TO_ITEM = (Map)Util.make((Object)Maps.newHashMap(), $$0 -> {
        $$0.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)EquipmentSlot.HEAD), Items.CHAINMAIL_HELMET);
        $$0.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)EquipmentSlot.CHEST), Items.CHAINMAIL_CHESTPLATE);
        $$0.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)EquipmentSlot.LEGS), Items.CHAINMAIL_LEGGINGS);
        $$0.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)EquipmentSlot.FEET), Items.CHAINMAIL_BOOTS);
        $$0.put(Pair.of((Object)ArmorMaterials.IRON, (Object)EquipmentSlot.HEAD), Items.IRON_HELMET);
        $$0.put(Pair.of((Object)ArmorMaterials.IRON, (Object)EquipmentSlot.CHEST), Items.IRON_CHESTPLATE);
        $$0.put(Pair.of((Object)ArmorMaterials.IRON, (Object)EquipmentSlot.LEGS), Items.IRON_LEGGINGS);
        $$0.put(Pair.of((Object)ArmorMaterials.IRON, (Object)EquipmentSlot.FEET), Items.IRON_BOOTS);
        $$0.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)EquipmentSlot.HEAD), Items.GOLDEN_HELMET);
        $$0.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)EquipmentSlot.CHEST), Items.GOLDEN_CHESTPLATE);
        $$0.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)EquipmentSlot.LEGS), Items.GOLDEN_LEGGINGS);
        $$0.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)EquipmentSlot.FEET), Items.GOLDEN_BOOTS);
        $$0.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)EquipmentSlot.HEAD), Items.NETHERITE_HELMET);
        $$0.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)EquipmentSlot.CHEST), Items.NETHERITE_CHESTPLATE);
        $$0.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)EquipmentSlot.LEGS), Items.NETHERITE_LEGGINGS);
        $$0.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)EquipmentSlot.FEET), Items.NETHERITE_BOOTS);
        $$0.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)EquipmentSlot.HEAD), Items.DIAMOND_HELMET);
        $$0.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)EquipmentSlot.CHEST), Items.DIAMOND_CHESTPLATE);
        $$0.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)EquipmentSlot.LEGS), Items.DIAMOND_LEGGINGS);
        $$0.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)EquipmentSlot.FEET), Items.DIAMOND_BOOTS);
        $$0.put(Pair.of((Object)ArmorMaterials.TURTLE, (Object)EquipmentSlot.HEAD), Items.TURTLE_HELMET);
    });
    private static final Map<ArmorMaterial, Map<EquipmentSlot, Item>> MAP = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        Map chainMap = (Map)Util.make((Object)Maps.newHashMap(), m -> {
            m.put(EquipmentSlot.HEAD, Items.CHAINMAIL_HELMET);
            m.put(EquipmentSlot.CHEST, Items.CHAINMAIL_CHESTPLATE);
            m.put(EquipmentSlot.LEGS, Items.CHAINMAIL_LEGGINGS);
            m.put(EquipmentSlot.FEET, Items.CHAINMAIL_BOOTS);
        });
        map.put((ArmorMaterial)ArmorMaterials.CHAIN.value(), chainMap);
        Map ironMap = (Map)Util.make((Object)Maps.newHashMap(), m -> {
            m.put(EquipmentSlot.HEAD, Items.IRON_HELMET);
            m.put(EquipmentSlot.CHEST, Items.IRON_CHESTPLATE);
            m.put(EquipmentSlot.LEGS, Items.IRON_LEGGINGS);
            m.put(EquipmentSlot.FEET, Items.IRON_BOOTS);
        });
        map.put((ArmorMaterial)ArmorMaterials.IRON.value(), ironMap);
        Map goldMap = (Map)Util.make((Object)Maps.newHashMap(), m -> {
            m.put(EquipmentSlot.HEAD, Items.GOLDEN_HELMET);
            m.put(EquipmentSlot.CHEST, Items.GOLDEN_CHESTPLATE);
            m.put(EquipmentSlot.LEGS, Items.GOLDEN_LEGGINGS);
            m.put(EquipmentSlot.FEET, Items.GOLDEN_BOOTS);
        });
        map.put((ArmorMaterial)ArmorMaterials.GOLD.value(), goldMap);
        Map netheriteMap = (Map)Util.make((Object)Maps.newHashMap(), m -> {
            m.put(EquipmentSlot.HEAD, Items.NETHERITE_HELMET);
            m.put(EquipmentSlot.CHEST, Items.NETHERITE_CHESTPLATE);
            m.put(EquipmentSlot.LEGS, Items.NETHERITE_LEGGINGS);
            m.put(EquipmentSlot.FEET, Items.NETHERITE_BOOTS);
        });
        map.put((ArmorMaterial)ArmorMaterials.NETHERITE.value(), netheriteMap);
        Map diamondMap = (Map)Util.make((Object)Maps.newHashMap(), m -> {
            m.put(EquipmentSlot.HEAD, Items.DIAMOND_HELMET);
            m.put(EquipmentSlot.CHEST, Items.DIAMOND_CHESTPLATE);
            m.put(EquipmentSlot.LEGS, Items.DIAMOND_LEGGINGS);
            m.put(EquipmentSlot.FEET, Items.DIAMOND_BOOTS);
        });
        map.put((ArmorMaterial)ArmorMaterials.DIAMOND.value(), diamondMap);
        Map turtleMap = (Map)Util.make((Object)Maps.newHashMap(), m -> m.put(EquipmentSlot.HEAD, Items.TURTLE_HELMET));
        map.put((ArmorMaterial)ArmorMaterials.TURTLE.value(), turtleMap);
    });
    private static final List<ResourceKey<TrimPattern>> TRIM_PATTERNS = List.of(TrimPatternsModule.ANCIENT);
    private static final List<ResourceKey<TrimMaterial>> TRIM_MATERIALS = List.of(TrimMaterials.QUARTZ, TrimMaterials.IRON, TrimMaterials.NETHERITE, TrimMaterials.REDSTONE, TrimMaterials.COPPER, TrimMaterials.GOLD, TrimMaterials.EMERALD, TrimMaterials.DIAMOND, TrimMaterials.LAPIS, TrimMaterials.AMETHYST);
    private static final ToIntFunction<ResourceKey<TrimPattern>> TRIM_PATTERN_ORDER = Util.createIndexLookup(TRIM_PATTERNS);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> TRIM_MATERIAL_ORDER = Util.createIndexLookup(TRIM_MATERIALS);

    private static Item getArmorItem(ArmorMaterial material, EquipmentSlot slot) {
        Map<EquipmentSlot, Item> slotMap = MAP.get(material);
        if (slotMap != null) {
            return slotMap.get(slot);
        }
        return null;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctx, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ycb_armor_trims").requires(source -> source.hasPermission(2))).executes(context -> DebugSpawnArmorTrimsCommand.spawnArmorTrims((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).getPlayerOrException())));
    }

    private static int spawnArmorTrims(CommandSourceStack source, Player player) {
        Level level = player.level();
        NonNullList armorTrims = NonNullList.create();
        Registry trimPatternRegistry = level.registryAccess().registryOrThrow(Registries.TRIM_PATTERN);
        Registry trimMaterialRegistry = level.registryAccess().registryOrThrow(Registries.TRIM_MATERIAL);
        trimPatternRegistry.stream().filter(pattern -> pattern.assetId().getNamespace().equals("yungscavebiomes")).sorted(Comparator.comparing(p -> TRIM_PATTERN_ORDER.applyAsInt((ResourceKey<TrimPattern>)((ResourceKey)trimPatternRegistry.getResourceKey(p).orElse(null))))).forEachOrdered(p -> trimMaterialRegistry.stream().sorted(Comparator.comparing(m -> TRIM_MATERIAL_ORDER.applyAsInt((ResourceKey<TrimMaterial>)((ResourceKey)trimMaterialRegistry.getResourceKey(m).orElse(null))))).forEachOrdered(m -> armorTrims.add((Object)new ArmorTrim(trimMaterialRegistry.wrapAsHolder(m), trimPatternRegistry.wrapAsHolder(p)))));
        BlockPos pos = player.blockPosition().relative(player.getDirection(), 5);
        Registry armorMaterialRegistry = source.registryAccess().registryOrThrow(Registries.ARMOR_MATERIAL);
        int numMats = armorMaterialRegistry.size() - 1;
        double $$8 = 3.0;
        int trimIndex = 0;
        int materialIndex = 0;
        for (ArmorTrim trim : armorTrims) {
            for (ArmorMaterial material : armorMaterialRegistry) {
                if (material == ArmorMaterials.LEATHER.value()) continue;
                double x = (double)pos.getX() + 0.5 - (double)(trimIndex % trimMaterialRegistry.size()) * 3.0;
                double y = (double)pos.getY() + 0.5 + (double)(materialIndex % numMats) * 3.0;
                double z = (double)pos.getZ() + 0.5 + (double)(trimIndex / trimMaterialRegistry.size() * 10);
                ArmorStand armorStand = new ArmorStand(level, x, y, z);
                armorStand.setYRot(180.0f);
                armorStand.setNoGravity(true);
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ArmorItem $$20;
                    Item armorItem = DebugSpawnArmorTrimsCommand.getArmorItem(material, slot);
                    if (armorItem == null) continue;
                    ItemStack armorItemStack = new ItemStack((ItemLike)armorItem);
                    armorItemStack.set(DataComponents.TRIM, (Object)trim);
                    armorStand.setItemSlot(slot, armorItemStack);
                    if (armorItem instanceof ArmorItem && ($$20 = (ArmorItem)armorItem).getMaterial() == ArmorMaterials.TURTLE) {
                        armorStand.setCustomName((Component)((TrimPattern)trim.pattern().value()).copyWithStyle(trim.material()).copy().append(" ").append(((TrimMaterial)trim.material().value()).description()));
                        armorStand.setCustomNameVisible(true);
                        continue;
                    }
                    armorStand.setInvisible(true);
                }
                level.addFreshEntity((Entity)armorStand);
                ++materialIndex;
            }
            ++trimIndex;
        }
        source.sendSuccess(() -> Component.literal((String)"Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

