/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.module.MobEffectModule;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class BuffetedOverlay
implements LayeredDraw.Layer {
    private static BuffetedOverlay INSTANCE;
    private static final ResourceLocation OVERLAY_TEXTURE;
    private static final int MAX_TICKS = 200;
    private static final float MAX_OPACITY = 1.0f;
    private static final float MIN_COLOR = 0.1f;
    private static final float MAX_COLOR = 0.9f;
    private int ticks;
    private float color = 0.5f;

    public static BuffetedOverlay getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BuffetedOverlay();
        }
        return INSTANCE;
    }

    public void render(@NotNull GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        float partialTicks = deltaTracker.getGameTimeDeltaPartialTick(false);
        Minecraft client = Minecraft.getInstance();
        if (client.player == null) {
            return;
        }
        if (!client.player.isAlive()) {
            this.ticks = 0;
        }
        int n = this.ticks = client.player.hasEffect(MobEffectModule.BUFFETED_EFFECT.getHolder()) ? Math.min(this.ticks + 1, 200) : Math.max(this.ticks - 1, 0);
        if (!client.player.isSpectator() && this.ticks > 0) {
            float opacity = Mth.clamp((float)((float)this.ticks / 200.0f), (float)0.0f, (float)1.0f);
            int packedLight = client.getEntityRenderDispatcher().getPackedLightCoords((Entity)client.player, partialTicks);
            int worldLight = Mth.clamp((int)Math.max(LightTexture.block((int)packedLight), LightTexture.sky((int)packedLight)), (int)0, (int)15);
            int currLight = (int)(this.color * 16.0f);
            int colorDiff = worldLight - currLight;
            this.color += 0.003f * (float)colorDiff;
            this.color = Mth.clamp((float)this.color, (float)0.1f, (float)0.9f);
            BuffetedOverlay.renderTextureOverlay(guiGraphics, this.color, this.color, this.color, opacity);
        }
    }

    private static void renderTextureOverlay(GuiGraphics guiGraphics, float r, float g, float b, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.setColor(r, g, b, alpha);
        guiGraphics.blit(OVERLAY_TEXTURE, 0, 0, -90, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    static {
        OVERLAY_TEXTURE = YungsCaveBiomesCommon.id("textures/overlay/buffeted_overlay.png");
    }
}

