/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class IceSheetBlock
extends MultifaceBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<IceSheetBlock> CODEC = IceSheetBlock.simpleCodec(IceSheetBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty GLOWING = BlockStateProperties.LIT;
    public static final IntegerProperty GROWTH_DISTANCE = BlockStateProperties.AGE_3;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);

    public IceSheetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GROWTH_DISTANCE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (random.nextFloat() < 0.25f && serverLevel.getBrightness(LightLayer.BLOCK, blockPos) > 12 - blockState.getLightBlock((BlockGetter)serverLevel, blockPos)) {
            serverLevel.removeBlock(blockPos, false);
        }
        if (random.nextFloat() < 0.05f) {
            this.spreadFromRandomFaceWithinBlock(blockState, serverLevel, blockPos, random);
            if ((Integer)blockState.getValue((Property)GROWTH_DISTANCE) > 0) {
                this.spreadFromRandomFaceTowardRandomDirection(blockState, serverLevel, blockPos, random);
            }
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        if (level.getBrightness(LightLayer.BLOCK, blockPos) <= 12 - blockState.getLightBlock((BlockGetter)level, blockPos) || random.nextFloat() < 0.2f) {
            // empty if block
        }
    }

    public BlockState updateShape(BlockState thisState, Direction directionToNeighbor, BlockState neighborState, LevelAccessor levelAccessor, BlockPos thisPos, BlockPos neighborPos) {
        if (((Boolean)thisState.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(thisPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(thisState, directionToNeighbor, neighborState, levelAccessor, thisPos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction neighborDirection) {
        BlockState updatedState;
        if (!this.isFaceSupported(neighborDirection)) {
            return null;
        }
        BlockPos neighborPos = blockPos.relative(neighborDirection);
        if (blockState.is((Block)this)) {
            updatedState = blockState;
        } else {
            BlockState blockState2 = updatedState = blockState.getFluidState().isSourceOfType((Fluid)Fluids.WATER) ? (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : this.defaultBlockState();
        }
        if (IceSheetBlock.canAttachTo((BlockGetter)blockGetter, (Direction)neighborDirection, (BlockPos)neighborPos, (BlockState)blockGetter.getBlockState(neighborPos))) {
            updatedState = (BlockState)updatedState.setValue((Property)IceSheetBlock.getFaceProperty((Direction)neighborDirection), (Comparable)Boolean.valueOf(true));
            BlockState adjacentBlock = blockGetter.getBlockState(neighborPos);
            if (adjacentBlock.is(BlockModule.CREEPING_ICE_GLOWS_ON)) {
                updatedState = (BlockState)updatedState.setValue((Property)GLOWING, (Comparable)Boolean.valueOf(true));
            }
        } else {
            updatedState = null;
        }
        return updatedState;
    }

    @NotNull
    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, BlockPos neighborPos, boolean bl) {
        if (level.isClientSide) {
            return;
        }
        for (Map.Entry entry : PipeBlock.PROPERTY_BY_DIRECTION.entrySet()) {
            BlockPos adjacentPos;
            BlockState adjacentBlock;
            Direction direction = (Direction)entry.getKey();
            BooleanProperty property = (BooleanProperty)entry.getValue();
            if (!((Boolean)blockState.getValue((Property)property)).booleanValue() || !(adjacentBlock = level.getBlockState(adjacentPos = blockPos.relative(direction))).is(BlockModule.CREEPING_ICE_GLOWS_ON)) continue;
            if (!((Boolean)blockState.getValue((Property)GLOWING)).booleanValue()) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)GLOWING, (Comparable)Boolean.valueOf(true)), 2);
            }
            return;
        }
        if (((Boolean)blockState.getValue((Property)GLOWING)).booleanValue()) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)GLOWING, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public FluidState getFluidState(BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(blockState);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{GLOWING, WATERLOGGED, GROWTH_DISTANCE});
    }

    public boolean spreadFromRandomFaceWithinBlock(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        List possibleSourceDirections = Lists.newArrayList((Object[])DIRECTIONS).stream().filter(direction -> IceSheetBlock.hasFace((BlockState)blockState, (Direction)direction)).collect(Collectors.toList());
        Collections.shuffle(possibleSourceDirections);
        for (Direction possibleSourceDirection : possibleSourceDirections) {
            List possibleTargetDirections = Lists.newArrayList((Object[])DIRECTIONS).stream().filter(direction -> direction.getAxis() != possibleSourceDirection.getAxis() && (Boolean)blockState.getValue((Property)IceSheetBlock.getFaceProperty((Direction)direction)) == false).collect(Collectors.toList());
            Collections.shuffle(possibleTargetDirections);
            for (Direction targetDirection : possibleTargetDirections) {
                BlockPos neighborPos;
                if (!IceSheetBlock.canAttachTo((BlockGetter)serverLevel, (Direction)targetDirection, (BlockPos)(neighborPos = blockPos.relative(targetDirection)), (BlockState)serverLevel.getBlockState(neighborPos))) continue;
                BlockState updatedState = (BlockState)blockState.setValue((Property)IceSheetBlock.getFaceProperty((Direction)targetDirection), (Comparable)Boolean.valueOf(true));
                BlockState adjacentBlock = serverLevel.getBlockState(neighborPos);
                if (adjacentBlock.is(BlockModule.CREEPING_ICE_GLOWS_ON)) {
                    updatedState = (BlockState)updatedState.setValue((Property)GLOWING, (Comparable)Boolean.valueOf(true));
                }
                serverLevel.setBlock(blockPos, updatedState, 2);
                return true;
            }
        }
        return false;
    }

    public boolean spreadFromRandomFaceTowardRandomDirection(BlockState spreadOriginBlockState, ServerLevel serverLevel, BlockPos spreadOriginBlockPos, RandomSource random) {
        ArrayList directions = Lists.newArrayList((Object[])DIRECTIONS);
        Collections.shuffle(directions);
        return directions.stream().filter(direction -> IceSheetBlock.hasFace((BlockState)spreadOriginBlockState, (Direction)direction)).anyMatch(direction -> this.spreadFromFaceTowardRandomDirection(spreadOriginBlockState, (LevelAccessor)serverLevel, spreadOriginBlockPos, (Direction)direction, random, false));
    }

    public boolean spreadFromFaceTowardRandomDirection(BlockState spreadOriginBlockState, LevelAccessor levelAccessor, BlockPos spreadOriginBlockPos, Direction faceDirection, RandomSource random, boolean bl) {
        List<Direction> list = Arrays.asList(DIRECTIONS);
        Collections.shuffle(list, new Random(random.nextLong()));
        return list.stream().anyMatch(targetDirection -> this.spreadFromFaceTowardDirection(spreadOriginBlockState, levelAccessor, spreadOriginBlockPos, faceDirection, (Direction)targetDirection, bl));
    }

    public boolean spreadFromFaceTowardDirection(BlockState spreadOriginBlockState, LevelAccessor levelAccessor, BlockPos spreadOriginBlockPos, Direction faceDirection, Direction targetDirection, boolean bl) {
        Optional<Pair<BlockPos, Direction>> optional = this.getSpreadFromFaceTowardDirection(spreadOriginBlockState, levelAccessor, spreadOriginBlockPos, faceDirection, targetDirection);
        if (optional.isPresent()) {
            Pair<BlockPos, Direction> pair = optional.get();
            return this.spreadToFace(levelAccessor, (BlockPos)pair.getFirst(), (Direction)pair.getSecond(), bl, spreadOriginBlockState);
        }
        return false;
    }

    private Optional<Pair<BlockPos, Direction>> getSpreadFromFaceTowardDirection(BlockState spreadOriginBlockState, LevelAccessor levelAccessor, BlockPos spreadOriginBlockPos, Direction faceDirection, Direction targetDirection) {
        if (targetDirection.getAxis() != faceDirection.getAxis() && IceSheetBlock.hasFace((BlockState)spreadOriginBlockState, (Direction)faceDirection) && !IceSheetBlock.hasFace((BlockState)spreadOriginBlockState, (Direction)targetDirection)) {
            Direction direction3;
            if (this.canSpreadToFace(levelAccessor, spreadOriginBlockPos, targetDirection, spreadOriginBlockState)) {
                return Optional.of(Pair.of((Object)spreadOriginBlockPos, (Object)targetDirection));
            }
            BlockPos blockPos2 = spreadOriginBlockPos.relative(targetDirection);
            if (this.canSpreadToFace(levelAccessor, blockPos2, faceDirection, spreadOriginBlockState)) {
                return Optional.of(Pair.of((Object)blockPos2, (Object)faceDirection));
            }
            BlockPos blockPos3 = blockPos2.relative(faceDirection);
            return this.canSpreadToFace(levelAccessor, blockPos3, direction3 = targetDirection.getOpposite(), spreadOriginBlockState) ? Optional.of(Pair.of((Object)blockPos3, (Object)direction3)) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean canSpreadToFace(LevelAccessor levelAccessor, BlockPos blockPos, Direction direction, BlockState spreadOriginBlockState) {
        BlockState blockState = levelAccessor.getBlockState(blockPos);
        if (!this.canSpreadInto(levelAccessor, blockState, blockPos, spreadOriginBlockState)) {
            return false;
        }
        BlockState blockState2 = this.getStateForPlacement(blockState, (BlockGetter)levelAccessor, blockPos, direction);
        return blockState2 != null;
    }

    private boolean spreadToFace(LevelAccessor levelAccessor, BlockPos blockPos, Direction direction, boolean bl, BlockState spreadOriginBlockState) {
        if (!spreadOriginBlockState.hasProperty((Property)GROWTH_DISTANCE)) {
            return false;
        }
        BlockState oldBlockState = levelAccessor.getBlockState(blockPos);
        BlockState newBlockState = this.getStateForPlacement(oldBlockState, (BlockGetter)levelAccessor, blockPos, direction);
        if (newBlockState != null) {
            newBlockState = (BlockState)newBlockState.setValue((Property)GROWTH_DISTANCE, (Comparable)Integer.valueOf((Integer)spreadOriginBlockState.getValue((Property)GROWTH_DISTANCE) - 1));
            if (bl) {
                levelAccessor.getChunk(blockPos).markPosForPostprocessing(blockPos);
            }
            return levelAccessor.setBlock(blockPos, newBlockState, 2);
        }
        return false;
    }

    private boolean canSpreadInto(LevelAccessor levelAccessor, BlockState blockState, BlockPos blockPos, BlockState spreadOriginBlockState) {
        return (blockState.isAir() || blockState.is((Block)this) && (Integer)blockState.getValue((Property)GROWTH_DISTANCE) < (Integer)spreadOriginBlockState.getValue((Property)GROWTH_DISTANCE) || blockState.is(Blocks.WATER) && blockState.getFluidState().isSource()) && levelAccessor.getBrightness(LightLayer.BLOCK, blockPos) <= 12 - blockState.getLightBlock((BlockGetter)levelAccessor, blockPos);
    }
}

