/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.placement;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsbridges.module.PlacementModifierTypeModule;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

@MethodsReturnNonnullByDefault
public class BridgePlacement
extends PlacementModifier {
    public static final MapCodec<BridgePlacement> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.INT.fieldOf("length").forGetter(bridgePlacement -> bridgePlacement.length), (App)Codec.INT.fieldOf("width").forGetter(bridgePlacement -> bridgePlacement.width), (App)Codec.INT.fieldOf("min_water_z").forGetter(bridgePlacement -> bridgePlacement.minWaterZ), (App)Codec.INT.fieldOf("max_water_z").forGetter(bridgePlacement -> bridgePlacement.maxWaterZ), (App)Codec.INT.fieldOf("width_offset").forGetter(bridgePlacement -> bridgePlacement.widthOffset), (App)Codec.INT.fieldOf("num_solid_blocks_needed").forGetter(bridgePlacement -> bridgePlacement.numSolidBlocksNeeded), (App)Codec.BOOL.optionalFieldOf("is_z_axis", (Object)true).forGetter(bridgePlacement -> bridgePlacement.isZAxis)).apply((Applicative)codec, BridgePlacement::new));
    public final int length;
    public final int width;
    public final int minWaterZ;
    public final int maxWaterZ;
    public int widthOffset;
    public int numSolidBlocksNeeded;
    public boolean isZAxis;

    private BridgePlacement(int length, int width, int minWaterZ, int maxWaterZ, int widthOffset, int numSolidBlocksNeeded, boolean isZAxis) {
        this.length = length;
        this.width = width;
        this.minWaterZ = minWaterZ;
        this.maxWaterZ = maxWaterZ;
        this.widthOffset = widthOffset;
        this.numSolidBlocksNeeded = numSolidBlocksNeeded;
        this.isZAxis = isZAxis;
    }

    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
        BlockPos.MutableBlockPos seaLevelMutable = blockPos.mutable();
        int seaLevel = placementContext.getLevel().getSeaLevel() - 1;
        seaLevelMutable.setY(seaLevel);
        for (int candidateMiddleMinorAxisOffset = this.width / 2 + this.widthOffset + 1; candidateMiddleMinorAxisOffset < 16 - this.width / 2 - this.widthOffset; ++candidateMiddleMinorAxisOffset) {
            for (int candidateStartMajorAxisOffset = 0; candidateStartMajorAxisOffset < 16; ++candidateStartMajorAxisOffset) {
                int minorAxisSolidOffset;
                int minorAxisSolidDist;
                int direction;
                BlockPos endingPos;
                BlockPos startingPos = this.isZAxis ? new BlockPos(blockPos.getX() + candidateMiddleMinorAxisOffset, seaLevel, blockPos.getZ() + candidateStartMajorAxisOffset) : new BlockPos(blockPos.getX() + candidateStartMajorAxisOffset, seaLevel, blockPos.getZ() + candidateMiddleMinorAxisOffset);
                BlockPos blockPos2 = endingPos = this.isZAxis ? new BlockPos(blockPos.getX() + candidateMiddleMinorAxisOffset, seaLevel, blockPos.getZ() + candidateStartMajorAxisOffset + this.length + 1) : new BlockPos(blockPos.getX() + candidateStartMajorAxisOffset + this.length + 1, seaLevel, blockPos.getZ() + candidateMiddleMinorAxisOffset);
                if (!placementContext.getBlockState(startingPos).canOcclude() || !placementContext.getBlockState(endingPos).canOcclude() || placementContext.getHeight(Heightmap.Types.WORLD_SURFACE, startingPos.getX(), startingPos.getZ()) > seaLevel + 1 || placementContext.getHeight(Heightmap.Types.WORLD_SURFACE, endingPos.getX(), endingPos.getZ()) > seaLevel + 1) continue;
                int numSolidBlocks = 1;
                Iterator iterator = Lists.newArrayList((Object[])new Integer[]{-1, 1}).iterator();
                block2: while (iterator.hasNext()) {
                    direction = (Integer)iterator.next();
                    for (minorAxisSolidDist = 1; minorAxisSolidDist <= this.width / 2; ++minorAxisSolidDist) {
                        minorAxisSolidOffset = direction * minorAxisSolidDist;
                        if (this.isZAxis) {
                            seaLevelMutable.set(startingPos.getX() + minorAxisSolidOffset, startingPos.getY(), startingPos.getZ());
                        } else {
                            seaLevelMutable.set(startingPos.getX(), startingPos.getY(), startingPos.getZ() + minorAxisSolidOffset);
                        }
                        if (!placementContext.getBlockState((BlockPos)seaLevelMutable).canOcclude() || placementContext.getHeight(Heightmap.Types.WORLD_SURFACE, seaLevelMutable.getX(), seaLevelMutable.getZ()) > seaLevel + 1) continue block2;
                        ++numSolidBlocks;
                    }
                }
                if (numSolidBlocks < this.numSolidBlocksNeeded) continue;
                numSolidBlocks = 1;
                iterator = Lists.newArrayList((Object[])new Integer[]{-1, 1}).iterator();
                block4: while (iterator.hasNext()) {
                    direction = (Integer)iterator.next();
                    for (minorAxisSolidDist = 1; minorAxisSolidDist <= this.width / 2; ++minorAxisSolidDist) {
                        minorAxisSolidOffset = direction * minorAxisSolidDist;
                        if (this.isZAxis) {
                            seaLevelMutable.set(endingPos.getX() + minorAxisSolidOffset, endingPos.getY(), endingPos.getZ());
                        } else {
                            seaLevelMutable.set(endingPos.getX(), endingPos.getY(), endingPos.getZ() + minorAxisSolidOffset);
                        }
                        if (!placementContext.getBlockState((BlockPos)seaLevelMutable).canOcclude() || placementContext.getHeight(Heightmap.Types.WORLD_SURFACE, seaLevelMutable.getX(), seaLevelMutable.getZ()) > seaLevel + 1) continue block4;
                        ++numSolidBlocks;
                    }
                }
                if (numSolidBlocks < this.numSolidBlocksNeeded) continue;
                boolean isAllWater = true;
                block6: for (int minorAxisWaterOffset = -this.width / 2; minorAxisWaterOffset <= this.width / 2; ++minorAxisWaterOffset) {
                    for (int majorAxisWaterOffset = this.minWaterZ; majorAxisWaterOffset <= this.maxWaterZ; ++majorAxisWaterOffset) {
                        if (this.isZAxis) {
                            seaLevelMutable.set(startingPos.getX() + minorAxisWaterOffset, seaLevel, startingPos.getZ() + majorAxisWaterOffset);
                        } else {
                            seaLevelMutable.set(startingPos.getX() + majorAxisWaterOffset, seaLevel, startingPos.getZ() + minorAxisWaterOffset);
                        }
                        if (placementContext.getBlockState((BlockPos)seaLevelMutable).liquid()) continue;
                        isAllWater = false;
                        continue block6;
                    }
                }
                if (!isAllWater) continue;
                return this.isZAxis ? Stream.of(new BlockPos(startingPos.getX() - this.width / 2 - this.widthOffset, seaLevel, startingPos.getZ() + 1)) : Stream.of(new BlockPos(startingPos.getX() + 1, seaLevel, startingPos.getZ() + this.width / 2 + this.widthOffset));
            }
        }
        return Stream.empty();
    }

    public PlacementModifierType<?> type() {
        return PlacementModifierTypeModule.BRIDGE_PLACEMENT;
    }
}

