/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.wstweaks;

import dev.shadowsoffire.wstweaks.WSTConfig;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber(modid="wstweaks")
public class WSTEvents {
    @SubscribeEvent
    public static void witherTransform(FinalizeSpawnEvent event) {
        Skeleton skeleton;
        Mob mob = event.getEntity();
        if (mob instanceof Skeleton && !(skeleton = (Skeleton)mob).isRemoved()) {
            RandomSource rand = event.getLevel().getRandom();
            if (!event.getLevel().isClientSide() && (skeleton.level().dimension() == Level.NETHER || WSTConfig.allBiomes && event.getLevel().getRawBrightness(skeleton.blockPosition(), 0) < 9 && rand.nextFloat() < WSTConfig.allBiomesChance)) {
                event.setCanceled(true);
                skeleton.getPersistentData().putBoolean("wst.removed", true);
            }
        }
    }

    @SubscribeEvent
    public static void join(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            if (e.getEntity().getPersistentData().getBoolean("wst.removed")) {
                e.setCanceled(true);
                WitherSkeleton witherSkel = (WitherSkeleton)skeleton.convertTo(EntityType.WITHER_SKELETON, true);
                if (witherSkel == null) {
                    return;
                }
                EventHooks.onLivingConvert((LivingEntity)skeleton, (LivingEntity)witherSkel);
                if (WSTConfig.giveBows) {
                    witherSkel.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BOW));
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleDropsEvent(LivingDropsEvent event) {
        WSTEvents.delSwords(event);
    }

    public static void delSwords(LivingDropsEvent event) {
        if (WSTConfig.delSwords && !event.getEntity().level().isClientSide && event.getEntity() instanceof AbstractSkeleton) {
            event.getDrops().removeIf(ie -> {
                ItemStack stack = ie.getItem();
                return stack.is(Items.STONE_SWORD) || stack.is(Items.BOW);
            });
        }
    }
}

