/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import java.util.LinkedList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class TitleRenderer<T> {
    public final LinkedList<T> recentEntries = new LinkedList();
    public Component displayedTitle = null;
    public Component displayedSubTitle = null;
    public int titleTimer = 0;
    public int cooldownTimer = 0;
    public int maxRecentListSize;
    public boolean enabled;
    public int titleFadeInTicks;
    public int titleDisplayTime;
    public int titleFadeOutTicks;
    public int titleTextcolor;
    public String titleDefaultTextColor;
    public boolean showTextShadow;
    public float titleTextSize;
    public int titleXOffset;
    public int titleYOffset;
    public boolean isTextCentered;

    public TitleRenderer(int maxRecentListSize, boolean enabled, int fadeInTicks, int displayTicks, int fadeOutTicks, String textColor, boolean showTextShadow, double textSize, int xOffset, int yOffset, boolean centerText) {
        this.maxRecentListSize = maxRecentListSize;
        this.enabled = enabled;
        this.titleFadeInTicks = fadeInTicks;
        this.titleDisplayTime = displayTicks;
        this.titleFadeOutTicks = fadeOutTicks;
        this.setColor(textColor);
        this.titleDefaultTextColor = textColor;
        this.showTextShadow = showTextShadow;
        this.titleTextSize = (float)textSize;
        this.titleXOffset = xOffset;
        this.titleYOffset = yOffset;
        this.isTextCentered = centerText;
    }

    public void renderText(float partialTicks, GuiGraphics guiGraphics) {
        if (this.displayedTitle != null && this.titleTimer > 0) {
            float age = (float)this.titleTimer - partialTicks;
            int opacity = 255;
            if (this.titleTimer > this.titleFadeOutTicks + this.titleDisplayTime) {
                float r = (float)(this.titleFadeInTicks + this.titleDisplayTime + this.titleFadeOutTicks) - age;
                opacity = (int)(r * 255.0f / (float)this.titleFadeInTicks);
            }
            if (this.titleTimer <= this.titleFadeOutTicks) {
                opacity = (int)(age * 255.0f / (float)this.titleFadeOutTicks);
            }
            if ((opacity = Mth.clamp((int)opacity, (int)0, (int)255)) > 8) {
                guiGraphics.pose().pushPose();
                if (this.isTextCentered) {
                    guiGraphics.pose().translate((double)Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2.0, (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2.0, 0.0);
                }
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(this.titleTextSize, this.titleTextSize, this.titleTextSize);
                int alpha = opacity << 24 & 0xFF000000;
                Font fontRenderer = Minecraft.getInstance().font;
                int titleWidth = fontRenderer.width((FormattedText)this.displayedTitle);
                this.drawBackdrop(guiGraphics, -10, titleWidth, this.titleTextcolor | alpha);
                int xOffset = this.isTextCentered ? this.titleXOffset + -titleWidth / 2 : this.titleXOffset;
                guiGraphics.drawString(fontRenderer, this.displayedTitle, xOffset, this.titleYOffset, this.titleTextcolor | alpha, this.showTextShadow);
                guiGraphics.pose().popPose();
                if (this.displayedSubTitle != null) {
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().scale(1.3f, 1.3f, 1.3f);
                    int subtitleWidth = fontRenderer.width((FormattedText)this.displayedSubTitle);
                    this.drawBackdrop(guiGraphics, 5, subtitleWidth, 0xFFFFFF | alpha);
                    guiGraphics.drawString(fontRenderer, this.displayedSubTitle, -subtitleWidth / 2, -35, 0xFFFFFF | alpha, this.showTextShadow);
                    guiGraphics.pose().popPose();
                }
                RenderSystem.disableBlend();
                guiGraphics.pose().popPose();
            }
        }
    }

    public void tick() {
        if (this.titleTimer > 0) {
            --this.titleTimer;
            if (this.titleTimer <= 0) {
                this.clearTimer();
            }
        }
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
        }
    }

    public void displayTitle(Component titleText, @Nullable Component subtitleText) {
        this.displayedTitle = titleText;
        this.titleTimer = this.titleFadeInTicks + this.titleDisplayTime + this.titleFadeOutTicks;
        if (subtitleText != null) {
            this.displayedSubTitle = subtitleText;
        }
    }

    public void clearTimer() {
        this.titleTimer = 0;
    }

    public void setColor(String textColor) {
        try {
            this.titleTextcolor = (int)Long.parseLong(textColor, 16);
        }
        catch (Exception e) {
            TravelersTitlesCommon.LOGGER.error("Text color {} is not a valid RGB color. Defaulting to white...", (Object)textColor);
            TravelersTitlesCommon.LOGGER.error(e.toString());
            this.titleTextcolor = 0xFFFFFF;
        }
    }

    public void addRecentEntry(T entry) {
        if (this.recentEntries.size() >= this.maxRecentListSize && this.recentEntries.size() > 0) {
            this.recentEntries.removeFirst();
        }
        if (this.maxRecentListSize > 0) {
            this.recentEntries.addLast(entry);
        }
    }

    public boolean matchesAnyRecentEntry(Predicate<T> entryMatchPredicate) {
        return this.recentEntries.stream().anyMatch(entryMatchPredicate);
    }

    protected void drawBackdrop(GuiGraphics guiGraphics, int yOffset, int width, int color) {
        int textBackgroundColor = Minecraft.getInstance().options.getBackgroundColor(0.0f);
        if (textBackgroundColor != 0) {
            int xOffset = -width / 2;
            guiGraphics.fill(xOffset - 2, yOffset - 2, xOffset + width + 2, yOffset + 9 + 2, FastColor.ARGB32.multiply((int)textBackgroundColor, (int)color));
        }
    }
}

