/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SFMResourceLocation {
    public static ResourceLocation fromNamespaceAndPath(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static ResourceLocation fromSFMPath(String path) {
        return SFMResourceLocation.fromNamespaceAndPath("sfm", path);
    }

    public static ResourceLocation fromMinecraftPath(String path) {
        return SFMResourceLocation.fromNamespaceAndPath("minecraft", path);
    }

    public static ResourceLocation parse(String expanded) {
        return ResourceLocation.parse((String)expanded);
    }

    @Nullable
    public static ResourceLocation tryParse(String expanded) {
        try {
            return SFMResourceLocation.parse(expanded);
        }
        catch (ResourceLocationException rle) {
            return null;
        }
    }

    public static <T> ResourceKey<Registry<T>> createSFMRegistryKey(String path) {
        return ResourceKey.createRegistryKey((ResourceLocation)SFMResourceLocation.fromSFMPath(path));
    }
}

