/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfm.common.program.linting.ProblemTracker;
import ca.teamdman.sfml.ast.Program;
import java.util.Iterator;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LabelUsedInProgramButNotPresentProgramLinter
implements IProgramLinter {
    @Override
    public void gatherWarnings(Program program, LabelPositionHolder labelPositionHolder, @Nullable ManagerBlockEntity managerBlockEntity, ProblemTracker tracker) {
        String label;
        int before = tracker.size();
        Iterator<String> iterator = program.referencedLabels().iterator();
        while (!(!iterator.hasNext() || labelPositionHolder.getPositions(label = iterator.next()).isEmpty() && tracker.add(LocalizationKeys.PROGRAM_WARNING_UNUSED_LABEL.get(label)).isSaturated())) {
        }
        if (tracker.size() > before) {
            tracker.add(LocalizationKeys.PROGRAM_REMINDER_PUSH_LABELS.get());
        }
    }

    @Override
    public void fixWarnings(Program program, LabelPositionHolder labels, ManagerBlockEntity manager, Level level, ItemStack disk) {
        labels.removeIf(label -> !program.referencedLabels().contains(label));
    }
}

