/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.common.component.ItemStackBox;
import ca.teamdman.sfm.common.registry.SFMDataComponents;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class FormItem
extends Item {
    public FormItem() {
        super(new Item.Properties());
    }

    public static ItemStack createFormFromReference(ItemStack stack) {
        stack = stack.copy();
        ItemStack formStack = new ItemStack((ItemLike)SFMItems.FORM_ITEM.get());
        formStack.set(SFMDataComponents.FORM_REFERENCE, (Object)new ItemStackBox(stack));
        formStack.setCount(stack.getCount());
        return formStack;
    }

    @MCVersionDependentBehaviour
    public static ItemStack getBorrowedReferenceFromForm(ItemStack stack) {
        return ((ItemStackBox)stack.getOrDefault(SFMDataComponents.FORM_REFERENCE, (Object)ItemStackBox.EMPTY)).stack();
    }

    @MCVersionDependentBehaviour
    public static ItemStack getCopiedReferenceFromForm(ItemStack stack) {
        return FormItem.getBorrowedReferenceFromForm(stack).copy();
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        ItemStack reference = FormItem.getBorrowedReferenceFromForm(pStack);
        if (!reference.isEmpty()) {
            pTooltipComponents.addAll(reference.getTooltipLines(pContext, null, pTooltipFlag));
        }
    }
}

