/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.containermenu.TestBarrelTankContainerMenu;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.util.SFMContainerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TestBarrelTankBlockEntity
extends BaseContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private final FluidTank tank = new FluidTank(1000);

    public TestBarrelTankBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(SFMBlockEntities.TEST_BARREL_TANK_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public boolean isValidBlockState(BlockState blockState) {
        return SFMBlockEntities.TEST_BARREL_BLOCK_ENTITY.get().isValid(blockState);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
    }

    public void clearContent() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getContainerSize() {
        return 27;
    }

    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)pSlot, (int)pAmount);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return ContainerHelper.takeItem(this.items, (int)pSlot);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        if (pSlot < 0 || pSlot >= this.items.size()) {
            return;
        }
        this.items.set(pSlot, (Object)pStack);
    }

    public boolean stillValid(Player pPlayer) {
        return SFMContainerUtil.stillValid((BlockEntity)this, pPlayer);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
    }

    protected Component getDefaultName() {
        return LocalizationKeys.TEST_BARREL_TANK_CONTAINER.getComponent();
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new TestBarrelTankContainerMenu(pContainerId, pInventory, this);
    }
}

