/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;

public class RippleParticle
extends FlatPlaneParticle {
    private final SpriteSet sprites;
    private final boolean translucent;

    protected RippleParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, boolean translucent, float scale) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.translucent = translucent;
        this.rotation.rotateX(1.5707964f);
        this.setSpriteFromAge(sprites);
        this.scale(scale);
        this.lifetime = 5;
        if (translucent) {
            this.alpha = 0.2f;
        }
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public ParticleRenderType getRenderType() {
        if (this.translucent) {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RippleParticle particle = new RippleParticle(level, x, y, z, this.sprites, false, options.f());
            particle.setColor(0.871f, 0.478f, 0.133f);
            return particle;
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RippleParticle(level, x, y, z, this.sprites, true, options.f());
        }
    }
}

