/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticleRenderTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;

public abstract class BaseWaterfallParticle
extends TextureSheetParticle {
    private final BlockPos.MutableBlockPos pos;
    private final Particle.LifetimeAlpha lifetimeAlpha;

    protected BaseWaterfallParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Particle.LifetimeAlpha lifetimeAlpha) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.lifetimeAlpha = lifetimeAlpha;
        this.alpha = lifetimeAlpha.startAlpha();
        this.pos = BlockPos.containing((double)x, (double)y, (double)z).mutable();
        if (ModConfigs.ENVIRONMENT.waterfalls.randomizeWaterfallParticleRotation) {
            this.oRoll = this.roll = (float)this.random.nextInt();
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        super.render(buffer, renderInfo, partialTicks);
        this.alpha = this.lifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, partialTicks);
    }

    public void tick() {
        super.tick();
        this.pos.set(this.x, this.y, this.z);
        if (this.onGround) {
            this.remove();
            return;
        }
        if (!this.level.getFluidState((BlockPos)this.pos).isEmpty()) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ModParticleRenderTypes.getBlendedOrTransparent();
    }
}

