/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.block;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractCauldronBlock.class})
public class AbstractCauldronBlockMixin {
    @ModifyReturnValue(method={"useItemOn"}, at={@At(value="RETURN")})
    private ItemInteractionResult spawnInteractionParticles(ItemInteractionResult result, @Local(argsOnly=true) BlockState state, @Local(argsOnly=true) Level level, @Local(argsOnly=true) BlockPos pos, @Local CauldronInteraction interaction) {
        if (level.isClientSide && result == ItemInteractionResult.SUCCESS) {
            RandomSource random = level.getRandom();
            if (ModConfigs.BLOCKS.cauldronUseParticles || ModConfigs.BLOCKS.cauldronCleanItemSounds) {
                TickerManager.schedule(2, () -> {
                    if (ModConfigs.BLOCKS.cauldronUseParticles) {
                        if (level.getFluidState(pos.above()).getAmount() >= 5) {
                            return;
                        }
                        BlockState newState = level.getBlockState(pos);
                        boolean isEmpty = newState.is(Blocks.CAULDRON);
                        double fluidHeight = Util.getCauldronFillHeight(isEmpty ? state : newState);
                        ParticleOptions particle = Util.getCauldronParticle(isEmpty ? state : newState);
                        if (fluidHeight > 0.0 && particle != null) {
                            for (int i = 0; i < 16; ++i) {
                                int xSign = MathUtil.nextSign(random);
                                int zSign = MathUtil.nextSign(random);
                                level.addParticle(particle, (double)pos.getX() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)xSign, (double)pos.getY() + fluidHeight, (double)pos.getZ() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)xSign, MathUtil.nextDouble(random, 0.15f) * (double)xSign, MathUtil.nextDouble(random, 0.35f), MathUtil.nextDouble(random, 0.15f) * (double)zSign);
                            }
                        }
                    }
                    if (ModConfigs.BLOCKS.cauldronCleanItemSounds && (interaction.equals((Object)CauldronInteraction.DYED_ITEM) || interaction.equals((Object)CauldronInteraction.BANNER) || interaction.equals((Object)CauldronInteraction.SHULKER_BOX))) {
                        Util.playClientSound(pos, ModSounds.CAULDRON_CLEAN_ITEM.get(), SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                    }
                });
            }
        }
        return result;
    }
}

