/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Explosion.class})
public class ExplosionMixin {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private float radius;
    @Shadow
    @Final
    private double x;
    @Shadow
    @Final
    private double y;
    @Shadow
    @Final
    private double z;

    @Inject(method={"finalizeExplosion"}, at={@At(value="HEAD")})
    private void addSplashes(boolean spawnParticles, CallbackInfo ci) {
        BlockPos pos;
        FluidState fluidState;
        if (spawnParticles && this.level.isClientSide && ModConfigs.ENTITIES.splashes.explosionsCauseSplashes && !(fluidState = this.level.getFluidState(pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z))).isEmpty()) {
            int blockY;
            int y = blockY = pos.getY();
            while ((double)y < (double)blockY + (double)this.radius * 1.5 + 1.0) {
                BlockPos currentPos = pos.atY(y);
                FluidState currentFluidState = this.level.getFluidState(currentPos);
                if (!fluidState.getType().isSame(currentFluidState.getType())) {
                    ParticleType<SplashEmitterParticleOptions> type;
                    if (this.level.getBlockState(currentPos).isSolidRender((BlockGetter)this.level, currentPos)) {
                        return;
                    }
                    Object object = fluidState.is(FluidTags.WATER) ? ModParticles.WATER_SPLASH_EMITTER.get() : (type = fluidState.is(FluidTags.LAVA) ? ModParticles.LAVA_SPLASH_EMITTER.get() : null);
                    if (type != null) {
                        BlockPos surfacePos = currentPos.below();
                        FluidState surfaceFluidState = this.level.getFluidState(surfacePos);
                        float scale = this.radius - (float)(y - blockY) / this.radius;
                        this.level.addAlwaysVisibleParticle((ParticleOptions)new SplashEmitterParticleOptions(type, scale, scale * (scale * 0.1f), -1.0f, -1), true, this.x, (double)((float)surfacePos.getY() + surfaceFluidState.getHeight((BlockGetter)this.level, surfacePos)) + 0.01, this.z, 0.0, 0.0, 0.0);
                    }
                    return;
                }
                ++y;
            }
        }
    }
}

